/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2014 All Rights Reserved.
 */
package com.baijia.tianxiao.constants;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @title CourseType
 * @desc 教学类型
 * @author wangzhigang
 * @date 2014年12月5日
 * @version 1.0
 */
public enum CourseType {

    ALL(-1, "全部"), UNKNOW(0, "未知"), OTO(1, "一对一"), // 一对一
    CLASS(2, "班课"), // 班课
    VIDEO(3, "视频课"), ORG_COURSE(4, "机构线下课"), TRIAL_COURSE(5, "试听课"),
    ORG_COURSE_1v1(8,"机构线下课1v1")
    ;

    private static final Map<Integer, String> map = Maps.newHashMap();

    static {
        map.put(OTO.getCode(), OTO.getNote());
        map.put(CLASS.getCode(), CLASS.getNote());
        map.put(VIDEO.getCode(), VIDEO.getNote());
        map.put(ORG_COURSE.getCode(), ORG_COURSE.getNote());
        map.put(TRIAL_COURSE.getCode(), TRIAL_COURSE.getNote());
    }

    private int code;
    private String note;

    private CourseType(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer code) {
        return map.get(code);
    }
}
