package com.baijia.tianxiao.util.upload;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.dto.upload.UploadResult.UploadFile;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import com.google.gson.Gson;

import lombok.extern.slf4j.Slf4j;

/**
 * @title FileUploadUtils
 * @desc TODO
 * @author cxm
 * @date 2015年12月3日
 * @version 1.0
 */
@Slf4j
public class FileUploadUtils {

    public static UploadResult.UploadFile uploadToRemote(Long uid, File file, boolean watermark) {
        UploadResult uploadResult = upload(uid, file, watermark);
        UploadResult.UploadFile uploadFile = null;

        if (uploadResult != null) {
            List<UploadFile> files = uploadResult.getFiles();
            if (files != null && !files.isEmpty()) {
                uploadFile = uploadResult.getFiles().get(0);
            }
        }
        log.info("upload file result:{} and get first upload file:{}", uploadResult, uploadFile);
        return uploadFile;
    }

    public static UploadResult upload(Long uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();
        Properties prop = PropertiesReader.getProperties("upload.properties");
        Map<String, File> files = Maps.newHashMap();
        Map<String, String> params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid", prop.getProperty("upload.uid.prefix", "tianxiao_") + uid);
        String url = prop.getProperty("upload.server");
        if (watermark) {
            url = url + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(url, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", uid, file, response);

        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", uid, (end - start));
        return parseResponse(response);
    }

    public static UploadResult uploadFiles(Long uid, Map<String, File> files, boolean watermark) {
        long start = System.currentTimeMillis();
        Properties prop = PropertiesReader.getProperties("upload.properties");
        Map<String, String> params = Maps.newHashMap();
        params.put("uid", prop.getProperty("upload.uid.prefix", "tianxiao_") + uid);
        String url = prop.getProperty("upload.server");
        if (watermark) {
            url = url + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(url, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", uid, files, response);

        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", uid, (end - start));
        return parseResponse(response);
    }

    /**
     * 文件上传
     * 
     * @param uploadServerHost 上传服务接口
     * @param uid 上传来源
     * @param file 文件
     * @param watermark 是否添加水印
     * @return
     */
    public static UploadResult uploadToRemote(String uploadServerHost, String uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();
        Map<String, File> files = Maps.newHashMap();
        Map<String, String> params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid", uid);
        if (watermark) {
            uploadServerHost = uploadServerHost + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(uploadServerHost, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", uid, file, response);

        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", uid, (end - start));
        return parseResponse(response);
    }

    public static UploadResult parseResponse(String response) {
        if (StringUtils.isBlank(response)) {
            return null;
        }

        UploadResult uploadResult = new Gson().fromJson(response, UploadResult.class);
        return uploadResult;
    }

    public static UploadResult.UploadFile parseResponseFile(UploadResult uploadResult) {

        UploadResult.UploadFile uploadFile = null;

        if (uploadResult != null) {
            List<UploadFile> files = uploadResult.getFiles();
            if (files != null && !files.isEmpty()) {
                uploadFile = uploadResult.getFiles().get(0);
            }
        }
        log.info("parseResponse - response:{}, uploadResult:{}", uploadResult, uploadFile);
        return uploadFile;
    }

}
