/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.util.collection;

import com.google.common.base.Function;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @title CollectorUtil
 * @desc TODO
 * @author cxm
 * @date 2015年9月27日
 * @version 1.0
 */
public class CollectorUtil {
    public static <K, V> Map<K, List<V>> group(Collection<V> values, Function<V, K> keyFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        Map<K, List<V>> result = new HashMap<K, List<V>>();
        for (V v : values) {
            K key = keyFun.apply(v);
            if (key != null) {
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList<V>());
                }
                result.get(key).add(v);
            }
        }
        return result;
    }

    public static <K, V, O> Map<K, List<V>> group(Collection<O> values, Function<O, K> keyFun,
        Function<O, V> valueFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        Map<K, List<V>> results = new HashMap<>();
        for (O o : values) {
            K key = keyFun.apply(o);
            if (key != null) {
                if (!results.containsKey(key)) {
                    results.put(key, new ArrayList<V>());
                }
                results.get(key).add(valueFun.apply(o));
            }
        }
        return results;
    }

    public static <K, V, O> Map<K, V> collectMap(Collection<O> values, Function<O, K> keyFun, Function<O, V> valueFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        Map<K, V> results = new HashMap<>();
        for (O o : values) {
            K key = keyFun.apply(o);
            if (key != null) {
                results.put(key, valueFun.apply(o));
            }
        }
        return results;
    }

    public static <K, O> Map<K, O> collectMap(Collection<O> values, Function<O, K> keyFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        Map<K, O> results = new HashMap<>();
        for (O o : values) {
            K key = keyFun.apply(o);
            if (key != null) {
                results.put(key, o);
            }
        }
        return results;
    }

    public static <K, V> Map<K, V> groupAndCalcu(Collection<V> values, Function<V, K> keyFun,
        Calculate<V> calculateFun) {
        return groupAndCalcu(values, null, keyFun, calculateFun);
    }

    public static <K, V> Map<K, V> groupAndCalcu(Collection<V> values, Map<K, V> result, Function<V, K> keyFun,
        Calculate<V> calculateFun) {
        if (result == null) {
            result = new HashMap<>();
        }
        if (CollectionUtils.isEmpty(values)) {
            return result;
        }
        for (V v : values) {
            K key = keyFun.apply(v);
            if (key != null) {
                result.put(key, calculateFun.calc(result.get(key), v));
            }
        }
        return result;
    }

    public static <K, O> Collection<K> collect(Collection<O> values, Function<O, K> keyFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        Set<K> results = new HashSet<>();
        for (O o : values) {
            K k = keyFun.apply(o);
            if (k != null) {
                results.add(k);
            }
        }
        return results;
    }

}
