package com.baijia.tianxiao.util.bean;

import java.lang.reflect.Constructor;

import org.apache.commons.lang.ArrayUtils;

/**
 * on 16/4/5.
 */
public class ReflectionUtil {
    @SuppressWarnings({ "rawtypes", "unchecked" })
    public static <T> T newInstance(Class<T> clazz) {
        Constructor constructor = getDefaultConstructorsOfClass(clazz);
        if (constructor == null) {
            return null;
        } else {
            try {
                Object e = constructor.newInstance();
                return (T) e;
            } catch (Exception ex) {
                return null;
            }
        }
    }

    @SuppressWarnings({ "rawtypes" })
    public static Constructor<?> getDefaultConstructorsOfClass(Class<?> clazz) {

        Constructor<?>[] constructors = getAllConstructorsOfClass(clazz);
        if (ArrayUtils.isEmpty(constructors)) {
            return null;
        }
        for (Constructor constructor : constructors) {
            if (constructor.getParameterTypes().length == 0) {
                return constructor;
            }
        }
        return null;
    }

    public static Constructor<?>[] getAllConstructorsOfClass(Class<?> clazz) {
        return clazz == null ? null : clazz.getDeclaredConstructors();
    }
}
