
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.util.bean;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Mar 1, 2017
 * @Desc this guy is too lazy, nothing left.
 */
public class LoggerService {

    public static void main(String[] args) throws URISyntaxException {
        // in current class log is not always useful
        LoggerService.info("hahah");
    }

    private static LoggerLevel settingLevel = LoggerLevel.INFO;

    private static LogService logService;

    private static String outputFild;

    private static final BlockingQueue<String> infoQueue = new LinkedBlockingQueue<>();

    static {
        initLogService();
    }

    private static void initLogService() {
        logService = new LogService(infoQueue);
        logService.setDaemon(true);
        String property = System.getProperty("user.dir");
        if (GenericsUtils.notNullAndEmpty(property)) {
            File file = new File(property);
            if (file != null && file.exists()) {
                outputFild = file.getParentFile().getAbsolutePath();
                outputFild += File.separator + "logs" + File.separator + "logService.log";
                System.out.println("======= outputFild is:" + outputFild);
            }
        }
        if (outputFild != null && outputFild.length() > 0) {
            setOutputFile(outputFild);
        }
        logService.start();
    }

    // private static final String line_separator = System.getProperty("line.separator");

    public static void info(Object...printObjs) {
        logMessage("", LoggerLevel.INFO, printObjs);
    }

    public static void info(String format, Object...printObjs) {
        logMessage(format, LoggerLevel.INFO, printObjs);
    }

    public static void infoArray(String format, Object printObjs) {
        logMessage(format, LoggerLevel.INFO, printObjs);
    }

    public static void debug(String format, Object...printObjs) {
        logMessage(format, LoggerLevel.DEBUG, printObjs);
    }

    public static void debugArray(String format, Object printObjs) {
        logMessage(format, LoggerLevel.DEBUG, printObjs);
    }

    public static void error(String format, Object...printObjs) {
        logMessage(format, LoggerLevel.ERROR, printObjs);
    }

    public static void errorArray(String format, Object printObjs) {
        logMessage(format, LoggerLevel.ERROR, printObjs);
    }

    public static void warn(String format, Object...printObjs) {
        logMessage(format, LoggerLevel.WARN, printObjs);
    }

    public static void warnArray(String format, Object...printObjs) {
        logMessage(format, LoggerLevel.WARN, printObjs);
    }

    public static void startLogService() {
        initLogService();
    }

    public static void stopLogService() {
        logService.stopLogService();
    }

    private static void logMessage(String format, LoggerLevel level, Object...printObjs) {
        printObjs = checkoutIfArray(printObjs);
        String formatOutput = format.replace("{}", "%s");
        if (format.equalsIgnoreCase(formatOutput) && (printObjs != null && printObjs.length != 0)) {
            for (int i = 0; i < printObjs.length; i++) {
                formatOutput += " %s ";
            }
        }
        createCodeInfos(String.format(formatOutput, checkoutIfIsExceptioin(printObjs)), level);
    }

    /**
     * @param printObjs
     * @return
     */
    private static Object[] checkoutIfIsExceptioin(Object...printObjs) {
        Object[] retObj = new Object[printObjs.length];
        for (int i = 0; i < printObjs.length; i++) {
            Object obj = retObj[i] = printObjs[i];
            if (obj instanceof Throwable) {
                retObj[i] = createExceptionOutput((Throwable) obj);
            }
        }
        return retObj;
    }

    /**
     * @param obj
     * @return
     */
    private static Object createExceptionOutput(Throwable obj) {
        StringWriter sw = new StringWriter();
        obj.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    /**
     * @param printObjs
     * @return
     */
    private static Object[] checkoutIfArray(Object...printObjs) {
        if (printObjs != null && printObjs.length == 1) {
            Object listObj = printObjs[0];
            if (listObj != null && listObj.getClass().isArray()) {
                Class<? extends Object> class1 = listObj.getClass();
                Object[] createArray = createArrayFromObj(listObj, class1);
                return new String[] { Arrays.toString(createArray) };
            }
        }
        return printObjs;
    }

    /**
     * @param listObj
     * @param class1
     * @return
     */
    private static Object[] createArrayFromObj(Object listObj, Class<? extends Object> class1) {
        Class<?> componentType = class1.getComponentType();
        int size = Array.getLength(listObj);
        Object[] createArray = createArray(componentType, size);
        for (int i = 0; i < size; i++) {
            createArray[i] = Array.get(listObj, i);
        }
        return createArray;
    }

    /**
     * @return
     */
    private static void createCodeInfos(String message, LoggerLevel level) {
        String printStr = message;
        if (checkLevel(level)) {
            printStr = createLoggerInfo(message, level, printStr);
            try {
                logService.log(printStr);
            } catch (Exception e) {
            }
        }
    }

    /**
     * @param message
     * @param level
     * @param printStr
     * @return
     */

    private static String createLoggerInfo(String message, LoggerLevel level, String printStr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Throwable t = new Throwable();
        t.printStackTrace(pw);
        String stackInfo = sw.toString();
        Scanner scanner = new Scanner(stackInfo);
        String line = null;
        scanner.nextLine(); // skip stack:exception xxx
        while (scanner.hasNextLine()) {
            line = scanner.nextLine();
            if (!line.trim().startsWith("at " + LoggerService.class.getName())) {
                break;
            }
        }
        scanner.close();
        if (line != null && line.length() > 0) {
            String retStr = line.substring(line.indexOf("at") + 3);
            printStr = LoggerInfos.instance(retStr, level, message);
        }
        return printStr;
    }

    /**
     * @param level2
     * @return
     */
    private static boolean checkLevel(LoggerLevel level) {
        return LoggerLevel.isOverLevel(settingLevel, level);
    }

    public static void setLoggerLevel(LoggerLevel level) {
        settingLevel = level;
    }

    /**
     * the log outputFile is not a thread safely
     * 
     * @param filePathName
     */
    public static void setOutputFile(String filePathName) {
        if (filePathName == null || filePathName.length() == 0) {
            return;
        }
        File outputFile = null;
        if (filePathName.contains(File.separator)) {
            outputFile = new File(filePathName);
        } else {
            if (!filePathName.contains(".")) {
                filePathName += ".log";
            }
            File classpath = getClasspath();
            if (classpath == null) {
                return;
            } else {
                outputFile = new File(classpath, filePathName);
            }
        }
        if (!outputFile.exists()) {
            try {
                outputFile.createNewFile();
            } catch (IOException e) {
                System.out.println("can not createOutputFile: " + outputFile.getAbsolutePath());
                return;
            }
        }
        System.out.println("==== output File is :{} " + outputFile.getAbsolutePath());
        try {
            PrintWriter outputFilePw = new PrintWriter(new FileWriter(outputFile, false), true);
            outputFild = outputFile.getAbsolutePath();
            logService.setPrintWriter(outputFilePw);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getClasspath() {
        File file = null;
        try {
            file = new File(LoggerService.class.getClassLoader().getResource("").toURI());
            return file;
        } catch (URISyntaxException e) {
        }
        return null;
    }

    @SuppressWarnings("unchecked")
    private static <T> T[] createArray(Class<T> type, int size) {
        return (T[]) Array.newInstance(type, size);
    }

    /**
     * @param string
     * @param message
     * @param id
     * @return
     */
    public static String formatOutput(String format, Object...params) {
        return String.format(format.replace("{}", "%s"), params);
    }

    private static class LogService extends Thread {
        BlockingQueue<String> outputInfoQueue;
        volatile AtomicBoolean isStopService = new AtomicBoolean(false);
        AtomicInteger needLogCount = new AtomicInteger(0);
        PrintWriter outputPw = null;

        /**
         * @param infoqueue
         */
        LogService(BlockingQueue<String> infoqueue) {
            this.outputInfoQueue = infoQueue;
            assert this.outputInfoQueue != null;
        }

        void log(String outputInfo) throws InterruptedException {
            if (isStopService()) {
                throw new IllegalStateException("logService is closeed");
            }
            needLogCount.incrementAndGet();
            this.outputInfoQueue.put(outputInfo);
        }

        void setPrintWriter(PrintWriter pw) {
            this.outputPw = pw;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        if (isStopService() && this.needLogCount.decrementAndGet() < 0) {
                            System.out.println("======Log Service Stop Successfully=====");
                            break;
                        }
                        String take = this.outputInfoQueue.take();
                        if (this.outputPw != null) {
                            this.outputPw.println(take);
                            this.outputPw.flush();
                        } else {
                            System.out.println(take);
                        }
                    } catch (InterruptedException interruptedException) {
                        System.out.println("receive a interruptedException , so will try to stop log service ");
                        this.isStopService.set(true);
                    }
                }
            } catch (Exception e) {
                throw new RuntimeException(e);
            } finally {
                if (this.outputPw != null) {
                    this.outputPw.close();
                }
            }
        }

        /**
         * @return
         */
        private boolean isStopService() {
            return this.isStopService.get();
        }

        void stopLogService() {
            synchronized (this) {
                this.isStopService.getAndSet(true);
                this.interrupt();
            }
        }

    }

    public static enum LoggerLevel {

        ERROR(0), WARN(1), INFO(2), DEBUG(3);

        public int sort;

        private LoggerLevel(int sort) {
            this.sort = sort;
        }

        public String getShow() {
            return this.name();// .toLowerCase();
        }

        public static boolean isOverLevel(LoggerLevel settingLevel, LoggerLevel currentLevel) {
            return settingLevel.sort >= currentLevel.sort;
        }

    }

    static class LoggerInfos {

        private String line;
        private String packageName;
        private String methodName;
        private String executeTime;

        private String stackLineInfo;

        LoggerInfos(String stackLineInfo) {
            this(stackLineInfo, "");
        }

        public LoggerInfos(String stackLineInfo, String timeInfo) {
            this.stackLineInfo = stackLineInfo;
            this.executeTime = timeInfo;
        }

        private static final String FORMAT = "%s %s [%s] %s : %s";

        public String simpleFormat(String output, LoggerLevel level) {
            return String.format(FORMAT, this.executeTime, Thread.currentThread().getName(), level.getShow(),
                this.stackLineInfo, output);
        }

        public static LoggerInfos instance(String stackInfo) {
            LoggerInfos li = new LoggerInfos(stackInfo, simpleFormatDateStr());
            return li;
        }

        public static String instance(String stackInfo, LoggerLevel level, String afterFormat) {
            LoggerInfos li = new LoggerInfos(stackInfo, simpleFormatDateStr());
            return li.simpleFormat(afterFormat, level);
        }

        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public static Date simpleFormatDateStr(String valueStr) {
            try {
                return sdf.parse(valueStr);
            } catch (ParseException e) {
                return new Date();
            }
        }

        public static String simpleFormatDateStr() {
            return sdf.format(new Date());
        }

        public String getLine() {

            return line;
        }

        public void setLine(String line) {

            this.line = line;
        }

        public String getPackageName() {

            return packageName;
        }

        public void setPackageName(String packageName) {

            this.packageName = packageName;
        }

        public String getMethodName() {

            return methodName;
        }

        public void setMethodName(String methodName) {

            this.methodName = methodName;
        }

        public String getExecuteTime() {

            return executeTime;
        }

        public void setExecuteTime(String executeTime) {

            this.executeTime = executeTime;
        }

        public String getStackLineInfo() {

            return stackLineInfo;
        }

        public void setStackLineInfo(String stackLineInfo) {

            this.stackLineInfo = stackLineInfo;
        }

    }

}
