
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.util.baidu;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.constants.CoordType;
import com.baijia.tianxiao.constants.OutputType;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dto.baidu.BaiduPlaceEncoderData;
import com.baijia.tianxiao.dto.baidu.BaiduPlaceEncoderResponse;
import com.baijia.tianxiao.dto.baidu.Location;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * 调用百度地图api
 * @title BaiduMapUtils
 * @desc TODO 
 * @author zhangbing
 * @date 2016年3月21日
 * @version 1.0
 */
@Slf4j
public class BaiduMapUtils {

    /**
     * 根据具体地址获取地址所在经纬度
     * @param address
     * @param area
     * @return
     * @throws UnsupportedEncodingException
     */
    public static Location getLngAndLat(String address, String area) throws UnsupportedEncodingException {
        if (StringUtils.isBlank(address) || StringUtils.isBlank(area)) {
            return null;
        }
        String location = URLEncoder.encode(address, "UTF-8");
        String region = URLEncoder.encode(area, "UTF-8");
        String api = "http://api.map.baidu.com/place/v2/search?q="+location+"&region="+region+"&output=json&ak=D36e39424f92710515ef398cecbe30b6";
        
        log.info("address:{}", address);
        String response = HttpClientUtils.doGet(api, null);
        if (StringUtils.isNotBlank(response)) {
            return parseResponse(response);
        }
        return null;
    }
    
    /**
     * 解析调用百度api返回的结果
     * @param response
     * @return
     */
    private static Location parseResponse(String response) {
        try {
            BaiduPlaceEncoderResponse data = JacksonUtil.str2Obj(response, BaiduPlaceEncoderResponse.class);
            if (data != null) {
                if (data.getStatus() == BizConf.FALSE) {
                    List<BaiduPlaceEncoderData> result = data.getResults();
                    if (result != null && !result.isEmpty()) {
                        BaiduPlaceEncoderData place = result.get(0);
                        return place.getLocation();
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
    
    /**
     * @Description  : 根据经纬度获取地理位置信息 
     *                 见 http://developer.baidu.com/map/index.php?title=webapi/guide/webservice-geocoding
     * @Author       : zhenyujian
     * @CreationDate : 2015年7月10日 下午5:05:00 
     *
     * @Return       : String
     * 
     * 返回json样例    : {"status":0,"result":{"location":{"lng":116.32298703399,"lat":39.983424051248},"formatted_address":"北京市海淀区中关村大街27号1101-08室","business":"中关村,人民大学,苏州街","addressComponent":{"city":"北京市","country":"中国","direction":"附近","distance":"7","district":"海淀区","province":"北京市","street":"中关村大街","street_number":"27号1101-08室","country_code":0},"poiRegions":[],"sematic_description":"北京远景国际公寓(中关村店)内0米","cityCode":131}}
     */
    public static String getLocationInfo(String lat, String lon, CoordType coordType, OutputType outputType, Integer pois){
        if(lat==null || lon==null){
            return null;
        }
        String url = "http://api.map.baidu.com/geocoder/v2/";
        Map<String,String> parameterMap = new HashMap<String,String>();
        parameterMap.put("ak", "D36e39424f92710515ef398cecbe30b6");
        parameterMap.put("location", lat+","+lon);//纬度，经度
        parameterMap.put("output", outputType.getValue());
        parameterMap.put("coordtype", coordType.getValue());
        parameterMap.put("pois", pois.toString());//是否返回周边地理位置节点 此处置为否
        
        return HttpClientUtils.doGet(url, parameterMap);
    }
    
}

    