package com.baijia.tianxiao.interceptor;

import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.util.http.WebCommonsUtils;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by wengshengli on 2017/4/19.
 */
@Slf4j
public class LogInterceptor extends HandlerInterceptorAdapter {

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
        throws Exception {
        log.info("Log interceptor:preHandle:{},{}", request.getRequestURL().toString());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
        ModelAndView modelAndView) throws Exception {
        log.info("Log interceptor:postHandle:{}", request.getRequestURL().toString());

    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
        throws Exception {
        String ip = WebCommonsUtils.getIpAddr(request);
        String domain = request.getServerName();
        String path = request.getRequestURI();
        Map<String, String> params = WebCommonsUtils.getParameterMap(request);
        Integer orgId = TianxiaoPCContext.getOrgId();
        Integer cascadeId = TianxiaoPCContext.getTXCascadeId();
        String logId = request.getParameter("logId");
        log.info("Log interceptor:afterCompletion:{},{},{},{},{},{}", ip, domain, path, params, orgId, cascadeId,
            logId);
    }

}
