
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;


public enum SignupErrorCode implements UniverseErrorCode {

    UNKNOW(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 1, "未知类型错误"),
    PURCHASE_NOT_SUCCEED(1001, "获取订单失败，稍后再试。"),
    PURCHASEID_ERROR(1002, "报名单号不存在或者与报名类型不符"), // 业务逻辑错误
    COURCE_CHANGE(1003, "已拆分的课程不能修改"), // 业务逻辑错误o
    REPEAT_SUBMIT(1004, "报名已经完成，不能重复报名"), // 业务逻辑错误
    TOTALPRICE_ERROR(1005, "订单总价不能为负或大于100000"), // 业务逻辑错误
    TOTALPRICE_NOTMATCH(1006, "所选课程总价与支付订单总价不符，请重新选择所有课程"), // 业务逻辑错误
    UNKNOWN_PURCHASE_STATUS(1007, "未知的报名类型"), // 业务逻辑错误
    REGISTER_FAILED(1008, "浅注册失败"), // 业务逻辑错误
    SIGNUPCOURSE_NULL(1009, "报名单未选择课程"), // 业务逻辑错误
    MOBILE_FORMATE_ERROR(1010, "手机号码格式错误"),
    PURCHASE_ID_INVALIDATE(1011, "订单不存在,请检查订单ID"),
    PURCHASE_ID_ALREADY_PAY_SUCC(1012, "订单已经支付完成,不需要再次支付"),
    SIGNUP_HAS_NOT_COURSE_INFO(1013, "报名单还没有课程信息,请先填写报名信息."),
    SEND_SMS_COUNT_TOO_SOON(1014, "已达到今天发送短信上限,请明天再试"),
    SIGNUP_SMS_KEY_INVALIDATE(1015, "无法找到订单,请重新发送短信"),
    SPLITPURCHASE_ERROR(1016, "拆分订单失败"), // 交互错误
    GETTRADENO_ERROR(1017, "获取交易流水号失败"), // 交互错误
    STUDENT_NOT_REGISTERD(1018, "学员不在花名册中"), // 交互错误
    STUDENT_PAY_ERROR(1019, "学生储值账户金额错误"), // 储值支付
    TRANSFER_CLASS_ERROR(1020, "转班报名金额错误"), // 转班
    TRANSFER_STUDENT_ERROR(1022, "转班学生错误"), // 转班
    TRANSFER_REFUND_ERROR(1023, "该学生订单有处于转班中的订单"),
    TRANSFER_ORDER_INVALIDATE(1024, "订单状态无效,请重新选择订单"),
    TRANSFER_LEFT_LESSON_NOT_ENOUGH(1025, "剩余课次不足,请重新选择订单"),
    TRANSFER_LEFT_AMOUNT_NOT_ENOUGH(1026, "剩余学费不足,请重新选择订单"),
    TRANSFER_LESSON_INVALIDATE(1027, "您选择转班的课节信息无效,请重新选择课节"),
    TRANSFER_LESSON_DELETED(1028, "您选择转班的课节已删除,请重新选择课节"),
    TRANSFER_EXPIRED(1029, "转班订单已过期"),
    TRANSFER_LESSON_KEXIAO(1030, "您选择转班的课节已课消,请重新选择课节"),
    SIGNUP_CANCEL(1031, "订单已取消"),
    ;

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private SignupErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    private SignupErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.SIGNUP, Platform.UNKNOW, code, msg);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public SignupErrorCode fromCode(int code) {
        for (SignupErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return UNKNOW;
    }

    public static void main(String[] args) {
        System.out.println(TRANSFER_EXPIRED.getSubsystemErrorCode());
    }
}
