package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.util.ErrorCodeUtil;

/**
 * @author cxm
 * @version 1.0
 * @title SendMsgErrorCode
 * @desc TODO
 * @date 2016年3月21日
 */
public enum SendMsgErrorCode implements UniverseErrorCode {

    PARAM_ERROR(400, "请求参数不合法"),

    MOBILE_INVALIDATE(405, "手机号码格式不正确"),

    MSG_CONTENT_EMPTY(402, "消息内容为空"),

    SENDER_ERROR(403, "发送人信息错误"),

    RECEIVER_ERROR(408, "接收人信息错误"),

    NOT_SMS_COUNT(500, "短信条数不足"),

    SYSTEM_ERROR(9999, "系统处理异常");

    private int code;
    private String message;

    SendMsgErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return Subsystem.MSG_CENTER;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return Platform.UNKNOW;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public SendMsgErrorCode fromCode(int code) {
        for (SendMsgErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return SendMsgErrorCode.SYSTEM_ERROR;
    }

    public static void main(String args[]) {
        System.out.println(ErrorCodeUtil.getUniverseErrorCode(PARAM_ERROR));
    }
}
