
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dto.query;

import com.baijia.tianxiao.dto.FieldShow;

import com.google.common.base.Preconditions;

import com.google.common.collect.Lists;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import lombok.Data;

/**
 * @title 列表响应数据
 * @desc
 * @author shanyu
 * @date 2016年3月14日
 * @version 1.0
 */
@Data
public class ResponseListDto<T> {

    public static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    public ResponseListDto(List<FieldShow> headers, List<T> datas)
        throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        setHeaders(headers);
        setDatas(datas);
    }

    /**
     * 列表头部信息
     */
    private List<FieldShow> headers;

    /**
     * 列表数据部分
     */
    private List<List<Object>> datas;

    private void setHeaders(List<FieldShow> headers) {
        this.headers = headers;
    }

    private void setDatas(List<T> datas)
        throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Preconditions.checkArgument(headers != null, "headers is null! ");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(datas), "datas is empty!");
        this.datas = Lists.newArrayList();
        for (T t : datas) {
            this.datas.add(getObjects(t));
        }
    }

    private List<Object> getObjects(T entry)
        throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Preconditions.checkArgument(entry != null, "the entry is null!");
        List<Object> result = Lists.newArrayList();
        for (FieldShow show : headers) {
            if (show != null && StringUtils.isNoneBlank(show.getName())) {
                result.add(propertyUtilsBean.getProperty(entry, show.getName()));
            }
        }
        return result;
    }

}
