package com.baijia.tianxiao.constants.sms;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author wangzhigang
 * @version 1.0
 * @title SmsMessageType
 * @desc TODO
 * @date 2015年1月9日
 */
public enum SmsMessageType {

    CODE(1, "验证码类型"), //
    NOTIFY(2, "通知类型"), //
    MARKETING(3, "营销类型"), //

    TIANXIAO_NOTIFY(101, "天校专用通知通道"),;

    private static final Map<Integer, String> map = Maps.newHashMap();

    static {
        map.put(CODE.getCode(), CODE.getNote());
        map.put(NOTIFY.getCode(), NOTIFY.getNote());
        map.put(MARKETING.getCode(), MARKETING.getNote());
    }

    private int code;
    private String note;

    private SmsMessageType(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer code) {
        return map.get(code);
    }
}
