
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * @title Show
 * @desc 展示属性
 * @author shanyu
 * @date 2016年3月11日
 * @version 1.0
 */
@Target({ METHOD, FIELD })
@Retention(RUNTIME)
public @interface Show {

    /**
     * 展示名
     * 
     * @return
     */
    public String name();

    /**
     * 是否锁定（1，锁定，0，未锁定）
     * 
     * @return
     */
    public int lock() default 0;

    /**
     * 排序规则:0,string；1，number;2，date
     * 
     * @return
     */
    public int type() default 0;

    /**
     * 是否可操作：0，不可操作；1，可操作
     * 
     * @return
     */
    public int operate() default 1;

    /**
     * 对应的po字段名，默认为本身
     * 
     * @return
     */
    public String poName() default "";

    /**
     * 展示类型：0，不展示；1，展示
     * 
     * @return
     */
    public int viewType() default 1;

}
