/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2014 All Rights Reserved.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Random;
import java.util.concurrent.TimeoutException;

/**
 * @author caoliang
 * @version 1.0
 * @title VerifyCodeUtil
 * @desc TODO
 * @date 2016年4月20日
 */
public class VerifyCodeUtil {

    public static final Logger logger = LoggerFactory.getLogger(VerifyCodeUtil.class);

    /**
     * 验证码30分钟过期
     */
    public static final int CODE_EXP_TIME = 30 * 60;

    /**
     * code发送间隔时间60s
     */
    public static final int CODE_INTERVAL_TIME = 60;

    /**
     * 天校短信统一前缀
     */
    public static final String TX_SMS_APP_PREFIX = "tx_sms_prefix_app_";

    public static final String TX_SMS_PC_PREFIX = "tx_sms_prefix_pc_";

    public static String getFromMemCache(String key) {
        String code = null;
        try {

            code = (String) MemcachedUtil.get(key);
        } catch (TimeoutException | InterruptedException | MemcachedException e) {
            logger.error("read code from memcached error:{}", e);
        }

        logger.info("read code:{} from memcached by key:{}", code, key);

        return code;
    }

    public static Boolean removeFromMemCache(String key) {
        Boolean result = null;
        try {

            result = MemcachedUtil.delete(key);
        } catch (TimeoutException | InterruptedException | MemcachedException e) {
            logger.error("delete code from memcached error:{}", e);
        }

        logger.info("delete code:{} from memcached by key:{}", result, key);
        return result;
    }

    public static String newCode() {

        StringBuilder builder = new StringBuilder();
        for (int count = 4; count > 0; count--) {
            builder.append(new Random().nextInt(10));
        }
        // return "123456";
        return builder.toString();
    }

    public static String newCodeAndCached(boolean isApp, String mobile, String key) {
        String code = newCode();
        try {
            MemcachedUtil.set(getCacheKey(isApp, mobile, key), CODE_EXP_TIME, code);
            MemcachedUtil.set(getIntervalKey(isApp, mobile, key), CODE_INTERVAL_TIME, code);
        } catch (TimeoutException | InterruptedException | MemcachedException e) {
            logger.error("save code to memcached error:{}", e);
            return null;
        }

        logger.info("new code:{} succeed, cache key:{}", code, getCacheKey(isApp, mobile, key));

        return code;
    }

    public static boolean hasSended(boolean isApp, String mobile, String key) {
        if (null != getFromMemCache(getIntervalKey(isApp, mobile, key))) {
            return true;
        }

        return false;
    }

    public static boolean valid(boolean isApp, String mobile, String code, String key) {
        String cachedCode = getFromMemCache(getCacheKey(isApp, mobile, key));
        logger.info("valid verify code expect:{},actual:{}", cachedCode, code);
        if(code.equals(cachedCode)){
            delete(isApp, mobile, code, key);
            return true;
        }else{
            return false;
        }
    }

    public static boolean delete(boolean isApp, String mobile, String code, String key) {
        Boolean result = removeFromMemCache(getCacheKey(isApp, mobile, key));
        return result;
    }

    private static String getCacheKey(boolean isApp, String mobile, String key) {
        if (isApp) {
            return TX_SMS_APP_PREFIX + key + "_VERIFY_CODE_" + mobile;
        }
        return TX_SMS_PC_PREFIX + key + "_VERIFY_CODE_" + mobile;
    }

    private static String getIntervalKey(boolean isApp, String mobile, String key) {
        if (isApp) {
            return TX_SMS_APP_PREFIX + key + "_VERIFY_CODE_INTERVAL_KEY_" + mobile;
        }
        return TX_SMS_PC_PREFIX + key + "_VERIFY_CODE_INTERVAL_KEY_" + mobile;
    }
}
