/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dto.signup;

import java.util.HashMap;
import java.util.Map;


/**
 * @title PurchaseType
 * @desc TODO
 * @author shanyu
 * @date 2015年11月10日
 * @version 1.0
 */

public enum PurchaseType {

    SIGNUP(15, "报名订单"), ;

    private PurchaseType(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private static Map<Integer, PurchaseType> map = new HashMap<Integer, PurchaseType>();

    static {
        for (PurchaseType purchaseType : PurchaseType.values()) {
            map.put(purchaseType.code, purchaseType);
        }
    }

    private int code;

    private String message;

    public int getCode() {

        return code;
    }

    public String getMessage() {

        return message;
    }

    public static PurchaseType getTypeByCode(Integer code) {
        return map.get(code);
    }

}
