package com.baijia.tianxiao.constants.sms;

import java.util.HashMap;
import java.util.Map;

/**
 * @title SmsSendResult
 * @desc TODO
 * @author wangzhigang
 * @date 2015年1月13日
 * @version 1.0
 */
public enum SmsSendResult {

    PENDING(0), // 待发送

    SUCCESS(1), // 成功
    FAILED(2), // 失败

    PROCESSING(3); // 处理中

    private int value;

    private static Map<Integer, SmsSendResult> map = new HashMap<Integer, SmsSendResult>();

    private SmsSendResult(int value) {
        this.value = value;
    }

    static {
        for (SmsSendResult result : SmsSendResult.values()) {
            map.put(result.getValue(), result);
        }
    }

    public int getValue() {
        return this.value;
    }

    public static SmsSendResult getSendResultByCode(Integer code) {
        return map.get(code);
    }
}
