package com.baijia.tianxiao.constants;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 账号启用/禁用状态
 * Created by wangsixia on 2017/1/19.
 */
public enum EnableStatus {

    ENABLED(0, "启用"),
    DISABLED(1, "禁用"),
    ;

    @Getter
    private int code;
    @Getter
    private String msg;

    private EnableStatus(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static final Map<Integer, EnableStatus> map = new HashMap<>();

    static {
        for (EnableStatus item : values()) {
            map.put(item.getCode(), item);
        }
    }

    public static String getMsgByCode(Integer code) {
        if (code != null && map.containsKey(code)) {
            return map.get(code).getMsg();
        } else {
            return "";
        }
    }

    public static EnableStatus getByCode(Integer code) {
        if (code != null && map.containsKey(code)) {
            return map.get(code);
        } else {
            return null;
        }
    }
}
