package com.baijia.tianxiao.constants;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 分类类型
 * Created by wangsixia on 2017/1/13.
 */
public enum CategoryType {

    NEWS(1, "新闻"),

    ;

    @Getter
    private int code;

    @Getter
    private String msg;

    private CategoryType(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static Map<Integer, CategoryType> map = new HashMap<>();

    static {
        for (CategoryType item : values()) {
            map.put(item.getCode(), item);
        }
    }

    public static CategoryType getBycode(Integer code) {
        if (code != null && map.containsKey(code)) {
            return map.get(code);
        } else {
            return null;
        }
    }
}
