package com.baijia.tianxiao.util.date;

import com.google.common.collect.Maps;

import org.joda.time.LocalDate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

/**
 * @Title : DateUtil
 * @Description :
 * @Author : zhenyujian
 * @Date : 2015年8月19日 上午11:27:28
 */
// @Slf4j
public class DateUtil {

    private static Map<Integer, String> chineseWeekDayMap = Maps.newHashMap();

    static {
        chineseWeekDayMap.put(Calendar.MONDAY, "一");
        chineseWeekDayMap.put(Calendar.TUESDAY, "二");
        chineseWeekDayMap.put(Calendar.WEDNESDAY, "三");
        chineseWeekDayMap.put(Calendar.THURSDAY, "四");
        chineseWeekDayMap.put(Calendar.FRIDAY, "五");
        chineseWeekDayMap.put(Calendar.SATURDAY, "六");
        chineseWeekDayMap.put(Calendar.SUNDAY, "日");
    }

    private DateUtil() {
    }

    public static Date getMinUnixDate() {
        return new Date(0);
    }

    public static long currentUnixTimestamp() {
        return System.currentTimeMillis() / 1000;
    }

    public static long date2UnixTimestamp(Date date) {
        return date.getTime() / 1000;
    }

    public static Date UnixTimestamp2Date(long timestamp) {
        return new Date(timestamp * 1000);
    }

    /**
     * Description:获取当天凌晨时间 如 2015-01-01 00:00:00
     *
     * @return Date
     * @author zhenyujian Date: 2015年8月8日 下午6:40:06
     */
    public static Date getCurrentDate() {
        Calendar today = Calendar.getInstance();
        today.set(today.get(Calendar.YEAR), today.get(Calendar.MONTH), today.get(Calendar.DATE), 0, 0, 0);
        Date date = new Date();
        date.setTime(today.getTimeInMillis() / 1000 * 1000);
        return date;
    }

    /**
     * 获取当天yyyyMMdd
     *
     * @return
     */
    public static String getToday() {
        return getDayStr(new Date());
    }

    /**
     * 获取昨天天yyyyMMdd
     *
     * @return
     */
    public static String getYesterday() {
        return getDayStr(getDayDiff(-1));
    }

    /**
     * 获取 输入月份的第一天
     *
     * @param date
     * @return
     */
    public static Date getFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(Calendar.YEAR), today.get(Calendar.MONTH), 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000 * 1000);
        return date;
    }

    /**
     * 获取 输入下个月份月份的第一天
     *
     * @param date
     * @return
     */
    public static Date getNextMonthFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(Calendar.YEAR), today.get(Calendar.MONTH) + 1, 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000 * 1000);
        return date;
    }

    /**
     * 获取星期
     *
     * @param date
     * @return
     */
    public static String getChineseWeekDay(Date date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        return chineseWeekDayMap.get(cl.get(Calendar.DAY_OF_WEEK));
    }

    /**
     * 获取汉字星期，星期日 0 星期一 1 ...
     *
     * @param date
     * @return
     */
    public static Integer getWeekDay(Date date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        return cl.get(Calendar.DAY_OF_WEEK) - 1;
    }

    /**
     * 获取上一个小时
     *
     * @return
     */
    public static Date getLastHourDate() {
        Calendar today = Calendar.getInstance();
        today.set(Calendar.HOUR, today.get(Calendar.HOUR) - 1);
        return today.getTime();
    }

    /**
     * 获取间隔天数,日期向前 负数,向后 正数,今天0
     *
     * @return
     */
    public static Date getDayDiff(int diff) {
        Calendar today = Calendar.getInstance();
        today.set(today.get(Calendar.YEAR), today.get(Calendar.MONTH), today.get(Calendar.DATE) + diff, 0, 0, 0);
        return today.getTime();
    }

    /**
     * Description: 获取与指定日期相差diff天 的 日期
     *
     * @param date
     * @param diff
     * @return Date
     * @author zhenyujian Date: 2015年8月10日 上午12:30:44
     */
    public static Date getDiffDateTime(Date date, int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, diff);
        return calendar.getTime();
    }

    public static Date getDiffHourTime(Date date, int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.HOUR_OF_DAY, diff);
        return calendar.getTime();
    }

    /**
     * Description: 获取与指定日期相差diff天 的 日期
     *
     * @param date
     * @param diff
     * @param field
     * @return Date
     * @author zhenyujian Date: 2015年8月10日 上午12:30:44
     */
    public static Date getDiffDateTime(Date date, int diff, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, diff);
        return calendar.getTime();
    }

    public static Date getDiffMinute(Date date, int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MINUTE, diff);
        return calendar.getTime();
    }

    /**
     * @Description : 指定时间是否处于上午
     * @Author : zhenyujian
     * @Date : 2015年12月1日 下午5:14:15
     * @Return : boolean
     */
    public static boolean whetherInTheAm(Date date) {
        GregorianCalendar ca = new GregorianCalendar();
        ca.setTime(date);
        if (ca.get(GregorianCalendar.AM_PM) == 0) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isToday(Date date) {
        Calendar today = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);

        if (today.get(Calendar.YEAR) == calendar.get(Calendar.YEAR)
                && today.get(Calendar.MONTH) == calendar.get(Calendar.MONTH)
                && today.get(Calendar.DATE) == calendar.get(Calendar.DATE)) {
            return true;
        }
        return false;
    }

    /**
     * 本年
     *
     * @return
     */
    public static int getThisYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.YEAR);
    }

    /**
     * 本月
     *
     * @return
     */
    public static int getThisMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.MONTH) + 1;
    }

    /**
     * 日期
     *
     * @return
     */
    public static String getDayStr(Date date) {
        return getStrByDateFormate(date, "yyyyMMdd");
    }

    public static String getAllDayStr(Date date) {
        return getStrByDateFormate(date, "yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 小时
     *
     * @return
     */
    public static String getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(Calendar.HOUR_OF_DAY));
    }

    /**
     * 分钟
     *
     * @return
     */
    public static String getMin(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(Calendar.MINUTE));
    }

    /**
     * 秒
     *
     * @return
     */
    public static String getSec(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(Calendar.SECOND));
    }

    /**
     * 根据年月日获取date
     *
     * @param year
     * @param month
     * @return
     */
    public static Date getDateByDay(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    /**
     * 根据年月获取月的第一天
     *
     * @param year
     * @param month
     * @return
     */
    public static Date getDateByYearMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, calendar.getMinimum(Calendar.DATE), 0, 0, 0);
        return calendar.getTime();
    }

    /**
     * 根据年月获取月的最后一天
     *
     * @param year
     * @param month
     * @return
     */
    public static Date endDateByYearMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        int value = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        calendar.set(Calendar.DAY_OF_MONTH, value);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        return calendar.getTime();
    }

    /**
     * 根据年月获取月的第一天
     *
     * @param year
     * @return
     */
    public static Date getDateByYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, 0, calendar.getMinimum(Calendar.DATE), 0, 0, 0);
        return calendar.getTime();
    }

    /**
     * 根据年月获取月的最后一天
     *
     * @param year
     * @return
     */
    public static Date endDateByYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, 11);
        int value = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        calendar.set(Calendar.DAY_OF_MONTH, value);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        return calendar.getTime();
    }

    /**
     * 获取月份差
     *
     * @param date1
     * @param date2
     * @return
     */
    public static int getMonthDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();

        c1.setTime(date1);
        c2.setTime(date2);

        return (c2.get(Calendar.YEAR) - c1.get(Calendar.YEAR)) * 12 + (c2.get(Calendar.MONTH) - c1.get(Calendar.MONTH));
    }

    /**
     * 获取日期差
     *
     * @param date1
     * @param date2
     * @return
     */
    public static int getDateDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();

        c1.setTime(date1);
        c2.setTime(date2);

        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        long days = (time2 - time1) / (1000 * 3600 * 24);

        return Integer.parseInt(String.valueOf(days));
    }

    /**
     * 获取日期差(分钟数)
     *
     * @param start
     * @param end
     * @return
     */
    public static int getMinuteDiff(Date start, Date end) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();

        c1.setTime(start);
        c2.setTime(end);

        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        long minutes = (time2 - time1) / (1000 * 60);

        return Integer.parseInt(String.valueOf(minutes));
    }

    public static long getSecondDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();

        c1.setTime(date1);
        c2.setTime(date2);

        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        long seconds = (time2 - time1) / (1000);

        return Long.parseLong(String.valueOf(seconds));
    }

    /**
     * @param format
     * @param str
     * @return
     */
    public static Date getStrToDate(String format, String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern(format);
        try {
            return simpleDateFormat.parse(str);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取基本的日期类型
     *
     * @param date
     * @return
     */
    public static Date getDateByStr(String date) {
        return getStrToDate("yyyy-MM-dd", date);
    }

    public static String getStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyy-MM-dd");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getHourStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat("HH:mm:ss");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getMonthStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyy-MM");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getStrByDateFormate(Date date, String formate) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat(formate);
        String str = dateformat1.format(date);
        return str;
    }

    public static Date getOffSetDate(Date date, int offSet) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(Calendar.DAY_OF_MONTH, offSet);
        return cal.getTime();
    }

    public static Date getOffSetDate(int offSet) {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH, offSet);
        return cal.getTime();
    }

    /**
     * Description: 日期大小比较 (时间精确到'日') start比end早,返回1, start与end相同,返回0, start比end晚,返回-1
     *
     * @param startDate
     * @param endDate
     * @return int
     * @author zhenyujian Date: 2015年8月5日 下午1:25:13
     */
    public static int dateCompare(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();

        start.setTime(startDate);
        end.setTime(endDate);

        start.set(start.get(Calendar.YEAR), start.get(Calendar.MONTH), start.get(Calendar.DATE), 0, 0, 0);
        end.set(end.get(Calendar.YEAR), end.get(Calendar.MONTH), end.get(Calendar.DATE), 0, 0, 0);

        long startTime = start.getTimeInMillis() / 1000;
        long endTime = end.getTimeInMillis() / 1000;

        if (startTime < endTime) {
            return 1;
        } else if (startTime > endTime) {
            return -1;
        } else {
            return 0;
        }
    }

    public static List<Date> getDateBetween(Date startDate, Date endDate) {
        List<Date> dates = new ArrayList<Date>();
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();

        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(Calendar.YEAR), start.get(Calendar.MONTH), start.get(Calendar.DATE), 0, 0, 0);
        end.set(end.get(Calendar.YEAR), end.get(Calendar.MONTH), end.get(Calendar.DATE), 0, 0, 0);

        Calendar current = start;
        while (dateCompare(current.getTime(), end.getTime()) > 0) {
            Date date = new Date();
            date.setTime(current.getTimeInMillis() / 1000 * 1000);
            dates.add(date);
            current.add(Calendar.DATE, 1);
        }
        Date date = new Date();
        date.setTime(current.getTimeInMillis() / 1000 * 1000);
        dates.add(date);
        current.add(Calendar.DATE, 1);

        return dates;
    }

    /**
     * 按照yyyy-mm-dd格式输出某时间端日期
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static List<String> getDateStrListBetween(Date startDate, Date endDate) {
        List<String> dateStrList = new ArrayList<>();
        // System.out.println("开始时间：" + DateUtil.getStrByDateFormate(startDate, "yyyy-MM-dd"));
        // System.out.println("结束时间：" + DateUtil.getStrByDateFormate(endDate, "yyyy-MM-dd"));
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        boolean bContinue = endDate.after(cal.getTime());
        while (bContinue) {
            dateStrList.add(DateUtil.getStrByDateFormate(cal.getTime(), "yyyy-MM-dd"));
            // System.out.println(DateUtil.getStrByDateFormate(cal.getTime(), "yyyy-MM-dd"));
            cal.add(Calendar.DAY_OF_MONTH, 1);
            bContinue = endDate.after(cal.getTime());
        }
        return dateStrList;
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        return calendar.getTime();
    }

    public static Date getStartOfHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        return calendar.getTime();
    }

    /**
     * 获取当前时间的下一个5分整除时间
     *
     * @param date
     * @return
     */
    public static Date getNext5MinDevide(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.MINUTE, (calendar.get(Calendar.MINUTE) / 5 + 1) * 5);
        calendar.set(Calendar.SECOND, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        return calendar.getTime();
    }

    public static Date getStartOfDayAccurateToMillSeconde(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);

        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    /**
     * 获取点整-小时
     *
     * @param date
     * @return
     */
    public static Date getDayByHour(Date date, int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, hour);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        return calendar.getTime();
    }

    public static String getCurrentYM() {
        Date date = new Date();
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyyMM");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getCurrentYM(Long time) {
        Date date = new Date(time);
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyyMM");
        String str = dateformat1.format(date);
        return str;
    }

    public static Date getStartOfWeek() {
        LocalDate now = new LocalDate();
        LocalDate time = now.dayOfWeek().withMinimumValue();
        return getStartOfDay(time.toDate());
    }

    public static Date getEndOfWeek() {
        LocalDate now = new LocalDate();
        LocalDate time = now.dayOfWeek().withMaximumValue();
        return getEndOfDay(time.toDate());
    }

    public static Date getStartOfMonth() {
        LocalDate now = new LocalDate();
        LocalDate time = now.dayOfMonth().withMinimumValue();
        return getStartOfDay(time.toDate());
    }

    public static Date getEndOfMonth() {
        LocalDate now = new LocalDate();
        LocalDate time = now.dayOfMonth().withMaximumValue();
        return getEndOfDay(time.toDate());
    }

    /**
     * Description: 日期大小比较 (时间精确到'miao') start比end早,返回true,start比end晚,返回false
     *
     * @param startDate
     * @param endDate
     * @return int
     * @author hlj Date: 2016年8月6日
     */
    public static boolean compare(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(Calendar.YEAR), start.get(Calendar.MONTH), start.get(Calendar.DATE),
                start.get(Calendar.HOUR), start.get(Calendar.MINUTE), start.get(Calendar.SECOND));
        end.set(end.get(Calendar.YEAR), end.get(Calendar.MONTH), end.get(Calendar.DATE), start.get(Calendar.HOUR),
                start.get(Calendar.MINUTE), start.get(Calendar.SECOND));
        long startTime = start.getTimeInMillis();
        long endTime = end.getTimeInMillis();

        if (startTime < endTime) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 支付时间要求,是今天的显示时分秒 非今天的显示日期
     *
     * @return
     */
    public static String getPayTime(Date date) {
        if (DateUtil.getStrByDate(date).equals(DateUtil.getStrByDate(new Date()))) {
            return getStrByDateFormate(date, "HH:mm");
        } else {
            return getStrByDateFormate(date, "MM-dd");
        }
    }

    public static Date getLastMinite(int i) {
        Calendar current = Calendar.getInstance();
        current.add(Calendar.MINUTE, -i);
        Date day = current.getTime();
        return day;
    }

    public static boolean validateTimestamp(Long time) {
        if (time == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 1, 1, 8, 0, 0);
        if (time < calendar.getTimeInMillis()) {
            return false;
        }
        calendar.set(2038, 1, 19, 3, 14, 7);
        if (time > calendar.getTimeInMillis()) {
            return false;
        }
        return true;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (dateCompare(date1, date2) == 0) {
            return true;
        }
        return false;
    }

    public static Date addMonth(Date date, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, month);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_YEAR, day);
        return calendar.getTime();
    }

    public static Date addHour(Date date, int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.HOUR_OF_DAY, hour);
        return calendar.getTime();
    }

    public static Date addMin(Date date, int min) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MINUTE, min);
        return calendar.getTime();
    }

    public static String secToTime(int seconds) {
        StringBuffer sb = new StringBuffer();
        int temp = 0;
        temp = seconds / 3600;
        sb.append((temp < 10) ? "0" + temp + ":" : "" + temp + ":");

        temp = seconds % 3600 / 60;
        sb.append((temp < 10) ? "0" + temp + ":" : "" + temp + ":");

        temp = seconds % 3600 % 60;
        sb.append((temp < 10) ? "0" + temp : "" + temp);
        return sb.toString();
    }

    public static void main(String args[]) throws Exception {
        // String string = DateUtil.getAllDayStr(new Date());
        // System.out.println(getDiffDateTime(new Date(),-5,12));
        // System.out.println(DateUtil.endDateByYearMonth(2015,11));
        //
        // // System.out.print(DateUtil.getStartOfDay(DateUtil.getDayDiff(-7)));
        // //
        // // int dd = DateUtil.getMinuteDiff(new Date(1463328000482l), new Date(1463356800000l));
        // // System.out.println(Math.ceil((float) dd / 60));
        // // System.out.println((float) dd / 60);
        //
        // System.out.println(new Date(1465949100000l));
        // System.out.println(new Date(1465951800000l));
        //
        // System.out.println(getDayDiff(-7));
        // System.out.println(getDayDiff(0));
        // System.out.println(getDayDiff(-2));
        //
        // System.out.println(getLastHourDate());
        // System.out.println(getLastHourDate());
        //
        // Calendar calendar = Calendar.getInstance();
        // Date date = new Date();
        // calendar.setTime(date);
        // calendar.set(2015, 12, 30, 0, 2);
        // System.out.println(calendar.getTime());
        //
        // SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        // Date testWeekDay = sdf.parse("2015-12-30");
        // System.out.println("weekday= " + testWeekDay + "" + getWeekDay(testWeekDay));
        //
        // calendar.set(Calendar.HOUR, calendar.get(Calendar.HOUR) - 1);
        //
        // System.out.println(calendar.getTime());
        //
        // System.out.println(getLastHourDate());
        //
        // System.out.println(new Date().getTime());
        //
        // System.out.println(DateUtil.getFirstDate(date));
        // System.out.println(DateUtil.getNextMonthFirstDate(date));
        //
        // System.out.println(DateUtil.getMonthDiff(new Date(), DateUtil.getDateByYearMonth(2015, 1)));
        //
        // System.out.println("---");
        // System.out.println(new Date(1480910400269L));
        // System.out.println(new Date(1480996800269L));
        // System.out.println(new Date(1481990400112L));
        // System.out.println(new Date(1482076800112L));
        // System.out.println("---");
        //
        // System.out.println(getStartOfDay(new Date()));
        //
        // System.out.println(getEndOfDay(new Date()));
        //
        // String html =
        // "简介描述撒打算的的撒的撒的撒的撒的撒的飒飒大<div>的飒飒大大爱上的</div><div>打算的撒的撒爱上的</div><div>大声说大阿萨德的撒的撒旦撒倒萨大</div><div>的撒啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊</div><div>的撒啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊</div><div>的撒啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊</div>";
        //
        // System.out.println(new Date());
        // System.out.println(new Date().getTime());
        // System.out.println(getDateByDay(2017,5,5).getTime());
        // System.out.println(getDiffMinute(new Date(), 60));
/*        Calendar today = Calendar.getInstance();
        today.set(2017, 1, 7, 15, 0, 0);
        System.out.println(today.getTime());
        System.out.println(getDateDiff(today.getTime(), new Date()));
        System.out.println(getDiffHourTime(new Date(), 1));
        System.out.println(DateUtil.getDiffDateTime(new Date(), -7 + 1));
        System.out.println(DateUtil.getDiffDateTime(new Date(), -7 + 0));
        System.out.println(new Date().getTime());
        System.out.println(new Date(1494321804000l));*/

        System.out.println(getDiffDateTime(new Date(),2));
        System.out.println(minutesToHourStr(200));
        String dateStr = getStrByDateFormate(new Date(), "M月d日HH:mm");
        System.out.println(dateStr);
    }

    public static String minutesToHourStr(Integer minutes) {
        String result = "";
        if (null == minutes || minutes < 0) {
            return result;
        } else {
            int hour = minutes / 60;
            if (hour > 0) {
                result += String.format("%s小时", hour);
                int minute = minutes % 60;
                if (minute > 0) {
                    result += String.format("%s分钟", minute);
                }
            } else {
                result += String.format("%s分钟", minutes);
            }
        }
        return result;
    }
}
