package com.baijia.tianxiao.enums;

import lombok.Getter;

/**
 * @author weihongyan
 * @implNote 维护所有redis key 前缀!!! 用法:getRedisKey() 或者直接 toString()
 * @since 15/04/2017
 */
public interface RedisKeyEnums {

    String SYSTEM_PREFIX = "tx";
    String SEPARATOR = ":";

    String getSUB_SYSTEM_PREFIX();

    String getBUSINESS_KEY();

    default String getRedisKey() {
        return SYSTEM_PREFIX + SEPARATOR + this.getSUB_SYSTEM_PREFIX() + SEPARATOR + this.getBUSINESS_KEY();
    }

    /**
     * crm-pc & crm-app
     */
    enum CRM implements RedisKeyEnums {
        CRM_PREFIX("", "key前缀"),

        APP_CONFIG_LIST_KEY("TX#APP#CONFIG#LIST", ""),

        MY_APP_CONFIG_IDS_KEY("TX#MY#APP#CONFIG#IDS#LIST", ""),

        WECHAT_REFRESH_ACCESSTOKEN_LOCK("wechat.refresh.accesstoken.lock.", ""),

        CONSULT_USER_ID_KEY("TX#CONSULT#ID", ""),

        CONSULTER_RELEASE_LOCK("consulter.release.lock", ""),

        TX_WECHAT_FANS_INTERVAL_PRE("tx_wechat_fans_interval_%s", ""),

        TX_NEW_ORG_PWD_KEY("_TX_NEW_ORG_PWD_KEY_", ""),

        TX_MOD_ORG_MOBILE_KEY("_TX_MOD_ORG_MOBILE_KEY_", ""),

        TX_INVITE_TOBE_CAMPUS_KEY("_TX_INVITE_TOBE_CAMPUS_KEY_", ""),

        LOCK_JSAPITICKET_1("lock.jsApiTicket_1.", ""),

        KEY_JSAPITICKET("key.jsApiTicket.", ""),

        TX_WECHAT_MEDIA_INTERVAL("tx_wechat_media_interval_%s", ""),

        WECHAT_MSG1("wechat.msg.%s", ""),

        WECHAT_MSG2("wechat.msg.%s.%s", ""),

        TX_PV_REDIS_PRE("TX#MONITOR#PV#", ""),

        TX_MSG_REDIS_PRE("TX#MESSAGE#PV#", ""),

        LAST_PUSH_NO_HASH("TX#LAST#PUSH#NO#HASH", ""),

        CONSULT_USER_AVATAR_HASH("TX#CONSULT#USER#AVATAR#HASH", ""),

        ORG_ACCOUNT_TYPE("TX#ORG#ACCOUNT#TYPE#HASH", ""),

        ORG_MESSAGE_KEY_PREFIX("TX#ORG#MESSAGE#", ""),

        CALL_AFTER_KEY_FORMAT("call_after:%s:%s", ""),

        REDIS_CRM_SMS_INTERVAL_KEY("CRM_SMS_CODE_INTERVAL_KEY_%s", ""),

        REDIS_CRM_SMS_KEY("CRM_SMS_CODE_KEY_%s", ""),

        WECHAT_CALLBACK_PREFIX("tx_webauth_", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "crm";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        CRM(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }

    }

    /**
     * erp-pc & erp-app
     */
    enum ERP implements RedisKeyEnums {
        ERP_PREFIX("", "key前缀"),

        TASK_SUFFIX("%s_task_tx", ""),

        STATUS_SUFFIX("%s_status_tx", ""),

        VALID_LIST_SUFFIX("%s_valid_list_tx", ""),

        INVALID_LIST_SUFFIX("%s_invalid_list_tx", ""),

        VALID_LIST_SIZE_SUFFIX("%s_valid_list_size_tx", ""),

        INVALID_LIST_SIZE_SUFFIX("%s_invalid_list_size_tx", ""),

        SIGINMSG_PREFIX("siginMsg_", ""),

        TX_ORG_KEXIAO_RULE("#TX#ORG#KEXIAO#RULE", ""),

        TX_ORG_STU_LESSON_UPDATE_HSET("#tx_org_stu_lesson_update_hset", ""),

        TX_ORG_STU_LESSON_UPDATE_TIME_FIVE("#TX#ORG#STU#LESSON#KEXIAO#FIVE", ""),

        UPLOAD_TASK_CACHE("UPLOAD_TASK_CACHE", ""),

        QUIT_STUDENT_CENTER_TOKEN("CENTER_TOKEN",""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "erp";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        ERP(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * finance-pc & finance-m
     */
    enum CW implements RedisKeyEnums {
        TX_SAVE_PAY_PWD_KEY("_TX_SAVE_PAY_PWD_KEY_", ""),

        TIANXIAO_SIGNUP_REDIS_PRE("TIANXIAO_SIGNUP_INFO_", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "cw";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        CW(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * tianxiao-m
     */
    enum M implements RedisKeyEnums {
        LOGIN_KEY_PREFIX("tx_login_code_", ""),

        CDDE_RETRY_KEY_PREFIX("tx_app_forget_password_retry_mobile_", ""),

        CDDE_KEY_PREFIX("tx_app_forget_password_mobile_", ""),

        REDIS_TIANXIAO_M_SMS_CODE_KEY("TIANXIAO_M_CODE_KEY_%s", ""),

        REDIS_TIANXIAO_M_SMS_CODE_INTERVAL_KEY("TIANXIAO_M_SMS_CODE_INTERVAL_KEY_%s", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "m";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        M(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * tianxiao-www
     */
    enum WWW implements RedisKeyEnums {
        WWW_PREFIX("", ""),

        TX_APPLY_KEY("_TX_APPLY_KEY_", ""),

        QR_LOGIN_PREFIX("tx_qr_login_", ""),

        QR_LOGIN_STATUS_PREFIX("tx_qr_login_status_", ""),

        QR_LOGIN_SID_PREFIX("tx_qr_login_sessionid_", ""),

        QR_LOGIN_TEMP_SESSION_PREFIX("tx_qr_temp_session_", ""),

        QR_LOGIN_APP_VERSION_PREFIX("tx_qr_app_version_", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "www";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        WWW(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * tianxiao-task
     */
    enum TASK implements RedisKeyEnums {
        TASK_PREFIX("", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "task";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        TASK(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * school
     */
    enum SCH implements RedisKeyEnums {
        TX_WX_LOGIN_CHECK_("tx_wx_login_check_", ""),

        TX_WX_LOGIN_("tx_wx_login_", ""),

        WX_HOME_MODEL_KEY_PREFIX("wx_home_model_Key_prefix_", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "sch";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        SCH(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * wangxiao
     */
    enum WX implements RedisKeyEnums {
        WX_PREFIX("", ""),

        CDDE_RETRY_KEY_PREFIX("tx_wangxiao_pc_login_retry_code_mobile_", ""),

        CDDE_KEY_PREFIX("tx_wangxiao_pc_login_mobile_", ""),

        PASSWORD_CDDE_KEY_PREFIX("tx_wangxiao_pc_find_pwd_mobile_", ""),

        WANGXIAO_PC_JUMP_TOKEN_PREFIX("tx_wangxiao_pc_login_jump_token_", ""),

        VALIDATECODEPREFIX("tx_wx_ValidateCode_", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "wx";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        WX(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * wangxiao-m
     */
    enum WXM implements RedisKeyEnums {
        TIANXIAO_M_INDEX_("TIANXIAO_M_INDEX_", ""),

        // FRONT_COOKIE_NAME("tx_school_m_front_ut", ""),

        // TX_WX_M_LOGIN_("tx_wx_m_login_", ""),

        LOGIN_PWD_ERRKEY_PREFIX("tx_wx_m_login_check_", ""),

        WX_HOME_MODEL_KEY_PREFIX("wx_m_home_model_Key_prefix_", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "wxm";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        WXM(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * tuiguang-m
     */
    enum HD implements RedisKeyEnums {
        SYNC_ONELINE_ARTICLE("SYNC_ONELINE_ARTICLE:%s", ""),

        EMAILCOUNTKEY("TX#ACTIVITY#EMAIL#COUNT", ""),

        DRAW_ACTIVITY_KEY("TX#ACTIVITY#DRAW", ""),

        VOTE_ACTIVITY_KEY("TX#ACTIVITY#VOTE", ""),

        ACTIVITY_VISITY_COUNT_KEY("TX#ACTIVITY#VISITY#COUNT", ""),

        ACTIVITY_VISITY_STATUS_KEY("TX#ACTIVITY#STATUS_NEW", ""),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "hd";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        HD(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }

    /**
     * vzhibo
     */
    enum VZB implements RedisKeyEnums {
        EVENT_KEY("vzhibo_event_marker_zset_keys_", ""),

        EVENT_KEY_LOCK("vzhibo_event_marker_lock", "事件持久化锁"),

        LESSON_DEVICEID_PREFIX("vzhibo_lesson_deviceId_", ""),

        VZHIBO_CONSULT_MOBILE_KEY("_VZHIBO_CONSULT_MOBILE_KEY_", ""),

        LOCK_FOR_PERSIST_MSG("lock.persist.msg.new", ""),

        MSG_QUEUE_LIVE_LESSONIDS("vzhibo_live_lessonIds", "有消息的话,就将当前直播课id添加到redis的“直播中”列表上"),

        ZHIBO("vzhibo_zhibo_", "主播区域"),

        DISCUSS("vzhibo_disc_", "讨论区"),

//        STUDENT_COUNT_PREFFIX("vzhibo_lesson_student_", "set,包含所有进过直播间的openid"),

        STUDENT_LATEST_VISIT("vzhibo_latest_visit_", ""),

        STUDENT_LATEST_VISIT_COUNT("vzhibo_latest_visit_count_", ""),

        REDIS_DISTRIBUTE_LOCK_TEST("test-test-test", "这就是个测试"),

        VZHIBO_INVITE_CARD_TASK_QUEUE("vzb_invite_card_task_queue", "微直播邀请卡生成任务队列"),

        VZHIBO_INVITE_CARD_TASK_GENERATING_ZSET("vzb_invite_card_task_generating_zset", "微直播邀请卡生成中有序时间戳集合(不丢任务,但有可能任务重复)"),

        VZHIBO_REGENERATE_INVITE_CARD_LOCK("vzb_regenerate_invite_card_", "重复请求生成邀请卡时间间隔"),

        ;
        @Getter
        private final String SUB_SYSTEM_PREFIX = "vzb";
        @Getter
        private String BUSINESS_KEY;
        @Getter
        private String DESC;

        VZB(String BUSINESS_KEY, String DESC) {
            this.BUSINESS_KEY = BUSINESS_KEY;
            this.DESC = DESC;
        }

        @Override
        public String toString() {
            return this.getRedisKey();
        }
    }
}
