
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.enums;

import java.util.Map;
import com.google.common.collect.Maps;

/**
 * @title OrgShowInfoType
 * @desc TODO 
 * @author zhangbing
 * @date 2016年3月16日
 * @version 1.0
 */
public enum OrgShowInfoType {

    COURSE(1, "课程列表"),

    CONSULT(2, "线索"),
    
    ORG_STUDENT(3, "学员档案")
    ;
    
    private static Map<Integer, OrgShowInfoType> cache;
    
    static {
        cache = Maps.newHashMap();
        cache.put(COURSE.getType(), COURSE);
        cache.put(CONSULT.getType(), CONSULT);
        cache.put(ORG_STUDENT.getType(), ORG_STUDENT);
    }
    
    private int type;
    
    private String label;
    
    private Class<?> clazz;
    
    private OrgShowInfoType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    /**
     * @return the type
     */
    
    public int getType() {
    
        return type;
    }

    /**
     * @param type the type to set
     */
    
    public void setType(int type) {
    
        this.type = type;
    }

    /**
     * @return the label
     */
    
    public String getLabel() {
    
        return label;
    }

    /**
     * @param label the label to set
     */
    
    public void setLabel(String label) {
    
        this.label = label;
    }

    /**
     * @return the clazz
     */
    
    public Class<?> getClazz() {
    
        return clazz;
    }

    /**
     * @param clazz the clazz to set
     */
    
    public void setClazz(Class<?> clazz) {
    
        this.clazz = clazz;
    }
    
    public static OrgShowInfoType get(int type) {
        return cache.get(type);
    }
    
    public static boolean contains(int type) {
        return cache.containsKey(type);
    }
}

    