
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;


/**
 * @title OrgErrorCode
 * @desc TODO 
 * @author zhangbing
 * @date 2015年12月4日
 * @version 1.0
 */

public enum OrgErrorCode implements UniverseErrorCode {
    
    UNKNOW(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 1 ,"未知类型错误"),
    
    USER_NOT_FOUND(1100, "用户不存在"),
    
    TEMPLATE_NOT_EXISTS(1101, "模板不存在"),
    
    NO_TEMPLATE_SELECTED(1102, "没有选择模板"),
    
    NO_SUBJECT_FOR_REQ(1103, "课程分类不存在"),
    
    COURSE_HAS_BEEN_GROUPED(1104, "该课程已分类"),
    
    
    COURSE_GROUP_NAME_OVERLENGTH(1105, "课程分组名称长度超过限制"),
    
    COURSE_GROUP_NAME_EXISTS(1106, "课程分组名称已存在"),
    
    ORG_NOT_EXISTS(1107, "机构不存在"),
    
    GET_ORG_INFO_FAILED(1108, "获取机构信息失败"),

    ORG_INFO_PHOTO_SIZE(1109, "APP最多上传50张照片"),

    ORG_INFO_PHOTO_ID(1110, "图片上传id错误"),
    
    ORG_NOT_BIND_WECHAT(1111,"主校区机构未绑定微信公众号,无法将分校区纳入统一公众号管理"),
    
    ORG_STILL_BIND_WECHAT(1112,"分校区机构当前已绑定公众号,请联系校区解绑公众号后才可以纳入共用公众号"),
    ;
    
    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;
    
    private OrgErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg){
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }
    
    private OrgErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.ORGANIZATION, Platform.PC, code, msg);
    }
    
    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode(){
        return code;
    }
    
    @Override
    public String getMessage(){
        return message;
    }
    
    @Override
    public OrgErrorCode fromCode(int code){
        for (OrgErrorCode errorCode:values()){
            if (errorCode.getSubsystemErrorCode()==code){
                return errorCode;
            }
        }
        return UNKNOW;
    }
}

    