
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.enums;

import java.util.Map;

import com.google.common.collect.Maps;


/**
 * 冲突类型
 * @title ConflictType
 * @desc TODO 
 * @author zhangbing
 * @date 2016年8月26日
 * @version 1.0
 */
public enum ConflictType {

    TEACHER_CONFLICT(0, "老师冲突"), ROOM_CONFLICT(1, "教室冲突"), ALL(2, "所有");
    
    private int type;
    
    private String label;
    
    private static Map<Integer, ConflictType> cache;
    
    static {
        cache = Maps.newHashMap();
        cache.put(TEACHER_CONFLICT.type, TEACHER_CONFLICT);
        cache.put(ROOM_CONFLICT.type, ROOM_CONFLICT);
    }
    
    private ConflictType(int type, String label) {
        this.type = type;
        this.label = label;
    }

    /**
     * @return the type
     */
    
    public int getType() {
    
        return type;
    }

    /**
     * @param type the type to set
     */
    
    public void setType(int type) {
    
        this.type = type;
    }

    /**
     * @return the label
     */
    
    public String getLabel() {
    
        return label;
    }

    /**
     * @param label the label to set
     */
    
    public void setLabel(String label) {
    
        this.label = label;
    }
    
    public static ConflictType get(int type) {
        return cache.get(type);
    }
}

    