/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dto.smstoken;


import java.util.Map;

import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.util.CourseSmsTokenUtil.SmsToken;

import lombok.Data;

/**   
 * @title       : WechatSmsTokenDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年9月1日 下午7:58:36 
 */
@Data
public class TeacherSmsTokenDto extends SmsTokenDto{
	 private Long orgId;
	 private String wechatAppId;
	 private Long teacherId;
	 private String openId;
	
	 private TeacherSmsTokenDto (){
	 }
	
	 public TeacherSmsTokenDto(Long orgId, String wechatAppId, Long teacherId, String openId){
		 this.orgId = orgId;
		 this.wechatAppId = wechatAppId;
		 this.teacherId = teacherId;
		 this.openId = openId;
	 }

	public static TeacherSmsTokenDto fromTokenStr(String tokenStr) throws Exception {
		TeacherSmsTokenDto obj = new TeacherSmsTokenDto();
		SmsToken token = CourseSmsTokenUtil.decodeToken(tokenStr);
		Map<String, Object> map = token.getParams();
		
		obj.setOrgId( map.get("orgId")!=null ? Long.parseLong(map.get("orgId").toString()) : null );
		obj.setWechatAppId( map.get("wechatAppId")!=null ? map.get("wechatAppId").toString() : null );
		obj.setTeacherId( map.get("teacherId")!=null ? Long.parseLong(map.get("teacherId").toString()) : null );
		obj.setOpenId( map.get("openId")!=null ? map.get("openId").toString() : null );
		
		return obj;
	}
	
	public static void main(String args[]) throws Exception{
		String token = "Cn0kdnUkPDM2OzI7ODMzMzg7MzkvJnN2a01oJj45ND47ODEndWZ3ZnJ5KECBKHprZ2lubHlQaylBOzs4Pz06PDQqd3htdlFtK0MreF9jXF9-V25XXnFCTEFYW1Vlen5OZE1VWFBFWS44Lnt-c1VwL0dCPUZDQDkvhHNxdm-CT35-V3IxSTGGh3VAQUdwc3JBdkJ2c0lDSEEzjj0zh3aDhHqBgDRMQ48";
		System.out.println(CourseSmsTokenUtil.decodeToken(token));
		System.out.println("1111");
		System.out.println(WechatSmsTokenDto.fromTokenStr("En0kdnUkPDM2OzI6NTo4OzcyMjcvJXJ1akxnJT06MzQ4Ny8lc2V2ZXF3Jj5_Jnd4eWhpcnhNaCc_c3pxcTEndHVqc05pJz8ndFRvNnd5OHk2dVRTN0k6dnY3V340Vnh-eIF-SCkzKXZ5blBrKUI_ODk9PDQqf21rcGl8SXh4UW0rQyuAgWpAQDlCOz85QkA7bUI8bEEshzYsgG98fXN5eCxEO4g"));
	}
}

