
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.constants.sms;

import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

/**
 * @title TxSmsCodeType
 * @desc TODO 
 * @author caoliang
 * @date 2016年4月20日
 * @version 1.0
 */

public enum TxSmsCodeType {
    
    APPLY(1,"申请试用天校","验证码%s，您正在申请体验天校，请在%s分钟内输入。详询客服4000910910", RedisKeyEnums.WWW.TX_APPLY_KEY.getRedisKey()),
    SAVE_PAY_PWD(2,"设置支付密码","验证码%s，您正在设置天校支付密码，请在%s分钟内输入。详询客服%s。",RedisKeyEnums.CW.TX_SAVE_PAY_PWD_KEY.getRedisKey()),
    INVITE_TOBE_CAMPUS(3,"邀请为分校区","验证码%s，〖%s〗申请绑定您在跟谁学上的校区〖%s〗。详询客服%s。",RedisKeyEnums.CRM.TX_INVITE_TOBE_CAMPUS_KEY.getRedisKey()),
    MOD_ORG_MOBILE(4,"修改主账户手机号","验证码%s，您正在修改绑定手机号，请在%s分钟内输入。详询客服%s。",RedisKeyEnums.CRM.TX_MOD_ORG_MOBILE_KEY.getRedisKey()),
    NEW_ORG_PWD(4,"浅注册密码短信","您已开通天校，用户名%s，初始密码%s请及时修改。App下载%s",RedisKeyEnums.CRM.TX_NEW_ORG_PWD_KEY.getRedisKey()),
    NEW_CASCADE_PWD(4," 邀请为子帐号","您已开通天校，用户名%s，初始密码%s请及时修改。App下载%s",RedisKeyEnums.CRM.TX_NEW_ORG_PWD_KEY.getRedisKey()),
    VZHIBO_CONSULT_MOBILE_KEY(5,"微直播发言，验证手机号","验证码%s，您正在绑定手机号，请在%s分钟内输入。详询客服%s。", RedisKeyEnums.VZB.VZHIBO_CONSULT_MOBILE_KEY.getRedisKey()),
    //学生课表
    STUDENT_CLASS_SCHEDULE(6,"学生课表","请查收『%s』的课表，地址%s 〖%s〗",null),
    //老师课表
    TEACHER_CLASS_SCHEDULE(7,"老师课表","请查收『%s』的课表，地址%s 〖%s〗",null),
    //上课提醒
    CLASS_NOTIFY(8,"上课提醒","上课提醒：%s您有『%s』课程，请记得准时参加。〖%s〗",null),
    //生日提醒
    BIRTHDAY_NOTIFY(9,"生日提醒","%s同学，〖%s〗祝你生日快乐，祝福你拥有金黄的岁月，璀璨的未来!",null),
    //报名
    SIGNUP_NOTIFY_WITH_SIGNAL(10,"报名通知","您已报名『%s』。〖%s〗",null), //如果是1门课，不显示“等X门课程”，1门以上的，显示第一门的课程名称+“等X门课程”。
    SIGNUP_NOTIFY_WITH_MANY(11,"报名通知","您已报名『%s』等%s门课程。〖%s〗",null), //如果是1门课，不显示“等X门课程”，1门以上的，显示第一门的课程名称+“等X门课程”。
    //签到完成
    SIGN_NOTIFY_PRESENT(12,"签到完成-到课","到课通知：%s同学，%s『%s』已到课。〖%s〗",null),
    SIGN_NOTIFY_NOT_PRESENT(12,"签到完成-未到课","未到课通知：%s同学，%s『%s』未到课。〖%s〗",null),
    SIGN_NOTIFY_LEAVE(12,"签到完成-请假","请假通知：%s同学，%s『%s』已请假。〖%s〗",null),
    //评价提醒
    COMMENT_NOTIFY(13,"评价提醒","%s老师点评了您%s的课堂表现，快去看看吧！%s〖%s〗",null),
    //提醒评价
    NOTIFY_TO_COMMENT(14,"提醒评价","评价邀请：%s的课结束了，请您给%s老师打个分吧！%s〖%s〗",null),
    //体验账号开通
    TRY_OPEN_TEMPLATE(15,"体验账号开通","您已开通天校体验，用户名%s，密码%s，%s天有效。App下载%s",null),
    //大众版开通
    OPEN_DAZHONGBAN(16,"大众版开通","您的天校大众版帐号申请已提交，我们很快会和您联系。详询客服%s",null),
    //体验账号过期提醒
    ONE_DAY_REMAIND_TEMPLATE(17,"体验账号过期","您的天校体验帐号还有1天到期，赶紧去体验吧。App下载:%s",null),
    //体验账号过期
    HAS_RELEASE_TEMPLATE(18,"体验账号过期","您的天校体验已到期，如需继续体验，可再次申请。详询客服%s",null),
    //解绑银行卡
    ORG_BANK_UNBIND_CARD(19,"银行卡解绑","您的天校帐号“%s”已解绑尾号%s的银行卡。详询客服%s。",null),
    //绑定银行卡
    ORG_BANK_BIND_CARD(20,"银行卡绑定","您的天校帐号“%s”已绑定尾号%s的银行卡。详询客服%s。",null),
    //学员/老师个人中心绑定
    BIND_WEIXIN(21,"个人中心绑定","验证码%s，您正在绑定个人中心，请在%s分钟内输入。〖%s〗",null),
    //找回密码
    FORGOTPWD_VALID_CODE_CONTENT(22, "找回密码", "验证码%s，您正在申请找回天校密码，请在%s分钟内输入。详询客服%s。", null),
    //营销群发短信
    TX_MARKTING_SMS(23, "群发短信", "[通知]   %s %s 回t退订【天校】", null),
    //验证码
    TX_VERTY_CODE(25, "验证码", "%s (验证码)。请勿转发，如非您本人操作，请忽略。", null),
    //咨询
    TX_CONSULT_RECALL(26,"咨询回访","%s 刚刚跟您进行了联系，如果希望进一步了解，请拨打电话%s。",null),
    TX_CONSULT_RECALL_CONTACT(27,"咨询回访带联系人","%s 的 %s 刚刚跟您进行了联系，如果希望进一步了解，请拨打电话%s。",null),
    //远程支付报名短信
    SIGNUP_PAY_SMS_CONTENT_SIGNAL_TEMPLATE(28,"正在报名","您正在报名『%s』。需点击缴费%s〖%s〗",null),
    SIGNUP_PAY_SMS_CONTENT_MANY_TEMPLATE(29,"正在报名","您正在报名『%s』等%s门课程。需点击缴费%s〖%s〗",null),
    //在线支付完成
    SIGNUP_COMPLETE_SMS_CONTENT_TEMPLATE(30,"在线支付完成","验证码%s，您正在报名，请在%s分钟内输入。〖%s〗",null),
    //M站报名短信验证码
    M_PAY_SMS_CODE(31,"M站报名短信验证码","验证码%s，您正在报名，请在%s分钟内输入。",null),

    ;
    
    private Integer code;
    private String label;
    private String msg;
    private String cacheKey;
    
    private static Map<String, TxSmsCodeType> noLogin = Maps.newHashMap();
    static{
        noLogin.put(APPLY.code.toString(), APPLY);
        noLogin.put(VZHIBO_CONSULT_MOBILE_KEY.code.toString(), VZHIBO_CONSULT_MOBILE_KEY);
    }
    
    
    TxSmsCodeType(Integer code, String label, String msg, String cacheKey){
        this.code = code;
        this.label = label;
        this.msg = msg;
        this.cacheKey = cacheKey;
    }

    public Integer getCode() {
    
        return code;
    }

    public void setCode(Integer code) {
    
        this.code = code;
    }

    public String getLabel() {
    
        return label;
    }

    public void setLabel(String label) {
    
        this.label = label;
    }
    
    public String getMsg() {
    
        return msg;
    }

    public void setMsg(String msg) {
    
        this.msg = msg;
    }

    public String getCacheKey() {
    
        return cacheKey;
    }

    public void setCacheKey(String cacheKey) {
    
        this.cacheKey = cacheKey;
    }

    public static boolean isTypeValid(String type){
        boolean result = false;
        if(StringUtils.isNotBlank(type)){
            for(TxSmsCodeType codeType : TxSmsCodeType.values()){
                if(codeType.getCode().toString().equals(type)){
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
    
    public static TxSmsCodeType getTxSmsCodeType(String type){
        TxSmsCodeType smsCodeType = null;
        if(StringUtils.isNotBlank(type)){
            for(TxSmsCodeType codeType : TxSmsCodeType.values()){
                if(codeType.getCode().toString().equals(type)){
                    smsCodeType = codeType;
                    break;
                }
            }
        }
        return smsCodeType;
    }
    
    public static String getSmsMsg(TxSmsCodeType codeType, String code){
        return codeType.msg.replace("{{code}}", code);
    }
    
    public static boolean noLogin(String type){
        return noLogin.containsKey(type);
    }
    
}

    