/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.constants.signup;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * @title PayResult
 * @desc TODO
 * @author cxm
 * @date 2015年9月8日
 * @version 1.0
 */
public enum PayResult {

    IN_PROGRESS(0, "待支付"),

    SUCCESS(1, "支付成功"),

    FAIL(2, "支付失败"),

    CANCEL(3, "取消支付"),

    ;
    private int code;

    private String note;

    private static Map<Integer, PayResult> map = Maps.newHashMap();

    private PayResult(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (PayResult pr : PayResult.values()) {
            map.put(pr.code, pr);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static PayResult getPayResultByCode(Integer code) {
        return map.get(code);
    }

    public static List<Integer> getPayResultList(Integer code) {
        if (code != null) {
            List<Integer> list = Lists.newArrayList();
            list.add(code);
            return list;
        }
        return null;
    }
}
