package com.baijia.tianxiao.base;

import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.util.WebResponseHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by wengshengli on 2017/4/21.
 */
@Slf4j
public class BaseController {

    @ExceptionHandler
    public WebResponse expHandle(HttpServletRequest request, Throwable ex) {

        if (ex instanceof IllegalArgumentException) {
            log.warn("BaseController IllegalArgumentException", ex);
            return WebResponseHelper.error(CommonErrorCode.PARAM_ERROR);
        } else if (ex instanceof BussinessException) {
            log.warn("BaseController BussinessException", ex);
            return WebResponseHelper.error(CommonErrorCode.BUSINESS_ERROR,ex.getMessage());
        } else if (ex instanceof PermissionException) {
            log.warn("BaseController PermissionException", ex);
            return WebResponseHelper.error(CommonErrorCode.PERMISSION_DENY);
        } else {
            log.error("BaseController Throwable =={}", ex);
            return WebResponseHelper.error(CommonErrorCode.SYSTEM_ERROR);
        }
    }
}
