
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import com.baijia.tianxiao.enums.PropertiesType;
import com.baijia.tianxiao.enums.QueryPolicy;


/**
 * @title Option
 * @desc TODO 
 * @author zhangbing
 * @date 2016年3月15日
 * @version 1.0
 */
@Target({ METHOD, FIELD })
@Retention(RUNTIME)
public @interface Option {

    //属性名称
    public String name();
    
    //属性对应中文名称
    public String showName();
    
    //属性类型
    public  PropertiesType type();
    
    //是否锁定
    public boolean lock() default false;
    
    //是否隐藏属性
    public boolean hidden() default false;
    
    //是否是默认属性值
    public boolean defaultProp() default false;
    
    //查询策略
    public QueryPolicy policy() default QueryPolicy.EQ;
    
    //查询字段
    public String queryProp() default "";
    
    //是否可排序0:false,1:true
    public int sort() default 1;
}

    