/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.redis.lock;

import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.redis.lock.RedisDistributeLock;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisOperations;

public class RedisDistributeLockImpl
implements RedisDistributeLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributeLockImpl.class);
    private RedisOperations<String, String> redisTemplate;
    private final Long defaultHoldLockExpMills = 60000L;
    private final Long defaultSpinMills = 200L;

    public RedisDistributeLockImpl(RedisOperations<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public RedisDistributeLock.LockObject lockFastFail(RedisKeyEnums keyEnums) {
        return this.lockFastFail(keyEnums, this.defaultHoldLockExpMills);
    }

    @Override
    public RedisDistributeLock.LockObject lockFastFail(@NonNull RedisKeyEnums keyEnums, long holdLockExpMills) {
        String json;
        if (keyEnums == null) {
            throw new NullPointerException("keyEnums");
        }
        Preconditions.checkArgument((holdLockExpMills > 0L ? 1 : 0) != 0, (Object)"\u9884\u8ba1\u9501\u6301\u6709\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0!");
        RedisDistributeLock.LockObject lockObject = new RedisDistributeLock.LockObject(holdLockExpMills);
        if (this.redisTemplate.opsForValue().setIfAbsent((Object)keyEnums.getRedisKey(), (Object)lockObject.toJson()).booleanValue() && this.redisTemplate.expire((Object)keyEnums.getRedisKey(), lockObject.getLockExpMills().longValue(), TimeUnit.MILLISECONDS).booleanValue()) {
            return lockObject;
        }
        Long expire = this.redisTemplate.getExpire((Object)keyEnums.getRedisKey(), TimeUnit.MILLISECONDS);
        if (expire < 0L && StringUtils.isNotBlank((CharSequence)(json = (String)this.redisTemplate.opsForValue().get((Object)keyEnums.getRedisKey())))) {
            RedisDistributeLock.LockObject noExpireLock = RedisDistributeLock.LockObject.formJson(json);
            this.redisTemplate.expire((Object)keyEnums.getRedisKey(), noExpireLock.getLockExpMills().longValue(), TimeUnit.MILLISECONDS);
            log.warn("[RedisDestributeLockImpl] lockFastFail find no expire lock! add expire done! lockKey:{}, oldExpire:{}ms, newExpire:{}ms, lock:{}", new Object[]{keyEnums, expire, noExpireLock.getLockExpMills(), json});
        }
        return null;
    }

    @Override
    public RedisDistributeLock.LockObject lockOrWait(RedisKeyEnums keyEnums, long waitMills) {
        return this.lockOrWait(keyEnums, waitMills, this.defaultHoldLockExpMills);
    }

    @Override
    public RedisDistributeLock.LockObject lockOrWait(RedisKeyEnums keyEnums, long waitMills, long holdLockExpMills) {
        return this.lockOrWait(keyEnums, waitMills, holdLockExpMills, this.defaultSpinMills);
    }

    @Override
    public RedisDistributeLock.LockObject lockOrWait(@NonNull RedisKeyEnums keyEnums, long waitMills, long holdLockExpMills, long spinMills) {
        if (keyEnums == null) {
            throw new NullPointerException("keyEnums");
        }
        Preconditions.checkArgument((holdLockExpMills > 0L ? 1 : 0) != 0, (Object)"\u9884\u8ba1\u9501\u6301\u6709\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0!");
        Preconditions.checkArgument((spinMills > 0L ? 1 : 0) != 0, (Object)"\u9884\u8ba1\u9501\u81ea\u65cb\u7b49\u5f85\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0!");
        long start = System.currentTimeMillis();
        RedisDistributeLock.LockObject result = null;
        while (waitMills < 0L || System.currentTimeMillis() - start < waitMills) {
            result = this.lockFastFail(keyEnums, holdLockExpMills);
            if (null == result) {
                try {
                    Thread.sleep(spinMills);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            log.info("[RedisDestributeLockImpl] get lock! key:{}, lock:{}", (Object)keyEnums, (Object)result.toJson());
            return result;
        }
        log.warn("[RedisDestributeLockImpl] lockOrWait failed! lockKey:{}, waitMills:{}, holdLockExpMills:{}, spinMils:{}", new Object[]{keyEnums, waitMills, holdLockExpMills, spinMills});
        return result;
    }

    @Override
    public boolean unlock(@NonNull RedisKeyEnums keyEnums, @NonNull RedisDistributeLock.LockObject lockObject) {
        if (keyEnums == null) {
            throw new NullPointerException("keyEnums");
        }
        if (lockObject == null) {
            throw new NullPointerException("lockObject");
        }
        String json = (String)this.redisTemplate.opsForValue().get((Object)keyEnums.getRedisKey());
        if (StringUtils.isNotBlank((CharSequence)json) && lockObject.equals(RedisDistributeLock.LockObject.formJson(json))) {
            this.redisTemplate.delete((Object)keyEnums.getRedisKey());
            log.debug("[RedisDestributeLockImpl] unlock success! lockKey:{}", (Object)keyEnums);
            return true;
        }
        log.warn("[RedisDestributeLockImpl] unlock failed! lockKey:{}, unlockObject:{}, lockObject:{}", new Object[]{keyEnums, lockObject.toJson(), json});
        return false;
    }
}

