/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.redis.lock;

import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.google.gson.Gson;
import java.util.UUID;
import lombok.NonNull;

public interface RedisDistributeLock {
    public LockObject lockFastFail(RedisKeyEnums var1);

    public LockObject lockFastFail(RedisKeyEnums var1, long var2);

    public LockObject lockOrWait(RedisKeyEnums var1, long var2);

    public LockObject lockOrWait(RedisKeyEnums var1, long var2, long var4);

    public LockObject lockOrWait(RedisKeyEnums var1, long var2, long var4, long var6);

    public boolean unlock(RedisKeyEnums var1, LockObject var2);

    public static class LockObject {
        String uuid = UUID.randomUUID().toString();
        Long ct = System.currentTimeMillis();
        Long lockExpMills;

        public LockObject(@NonNull Long lockExpMills) {
            if (lockExpMills == null) {
                throw new NullPointerException("lockExpMills");
            }
            this.lockExpMills = lockExpMills;
        }

        public String toJson() {
            return new Gson().toJson((Object)this);
        }

        public static LockObject formJson(String json) {
            return (LockObject)new Gson().fromJson(json, LockObject.class);
        }

        public String getUuid() {
            return this.uuid;
        }

        public Long getCt() {
            return this.ct;
        }

        public Long getLockExpMills() {
            return this.lockExpMills;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public void setCt(Long ct) {
            this.ct = ct;
        }

        public void setLockExpMills(Long lockExpMills) {
            this.lockExpMills = lockExpMills;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LockObject)) {
                return false;
            }
            LockObject other = (LockObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uuid = this.getUuid();
            String other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
                return false;
            }
            Long this$ct = this.getCt();
            Long other$ct = other.getCt();
            if (this$ct == null ? other$ct != null : !((Object)this$ct).equals(other$ct)) {
                return false;
            }
            Long this$lockExpMills = this.getLockExpMills();
            Long other$lockExpMills = other.getLockExpMills();
            return !(this$lockExpMills == null ? other$lockExpMills != null : !((Object)this$lockExpMills).equals(other$lockExpMills));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LockObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
            Long $ct = this.getCt();
            result = result * 59 + ($ct == null ? 43 : ((Object)$ct).hashCode());
            Long $lockExpMills = this.getLockExpMills();
            result = result * 59 + ($lockExpMills == null ? 43 : ((Object)$lockExpMills).hashCode());
            return result;
        }

        public String toString() {
            return "RedisDistributeLock.LockObject(uuid=" + this.getUuid() + ", ct=" + this.getCt() + ", lockExpMills=" + this.getLockExpMills() + ")";
        }
    }
}

