/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dto.builder;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.dto.builder.AppWebResponse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MapResponseBuilder
extends BaseDto {
    private PageDto pageDto;
    private Map<String, Object> data;
    private Object dataObj;
    private UniverseErrorCode errorCode;
    private String errorMsg;

    private MapResponseBuilder() {
    }

    public static MapResponseBuilder create() {
        return new MapResponseBuilder();
    }

    public static MapResponseBuilder create(UniverseErrorCode errorCode) {
        MapResponseBuilder builder = new MapResponseBuilder();
        builder.setErrorCode(errorCode);
        return builder;
    }

    public static MapResponseBuilder create(UniverseErrorCode errorCode, String errorMsg) {
        MapResponseBuilder builder = new MapResponseBuilder();
        builder.setErrorCode(errorCode, errorMsg);
        return builder;
    }

    public static MapResponseBuilder create(Map<String, Object> data, PageDto pageDto) {
        MapResponseBuilder builder = new MapResponseBuilder();
        builder.setData(data);
        builder.setPageDto(pageDto);
        return builder;
    }

    public static MapResponseBuilder create(Object data, PageDto pageDto) {
        MapResponseBuilder builder = new MapResponseBuilder();
        if (data != null) {
            for (Field field : data.getClass().getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(data);
                    if (value == null) continue;
                    builder.addData(field.getName(), value);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        builder.setPageDto(pageDto);
        return builder;
    }

    public static MapResponseBuilder create(Object data) {
        MapResponseBuilder builder = new MapResponseBuilder();
        if (data != null) {
            builder.setData(data);
        }
        return builder;
    }

    public MapResponseBuilder setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
        return this;
    }

    public MapResponseBuilder setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public MapResponseBuilder setData(Object obj) {
        this.dataObj = obj;
        return this;
    }

    public MapResponseBuilder addData(String key, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key}), (Object)"data key can not be empty");
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, value);
        return this;
    }

    public MapResponseBuilder setErrorCode(UniverseErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public MapResponseBuilder setErrorCode(UniverseErrorCode errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        return this;
    }

    public WebResponse<?> build() {
        AppWebResponse result = null;
        result = this.errorCode != null ? new AppWebResponse(this.errorCode) : new AppWebResponse();
        if (this.dataObj != null) {
            result.setData(this.dataObj);
        } else {
            result.setData(this.data);
        }
        result.setPageDto(this.pageDto);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.errorMsg})) {
            result.setMsg(this.errorMsg);
        }
        return result;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int code = 0;
        if (this.errorCode != null) {
            code = this.errorCode.getSubsystemErrorCode();
            if (StringUtils.isBlank((CharSequence)this.errorMsg)) {
                this.errorMsg = this.errorCode.getMessage();
            }
        }
        result.put("code", code);
        if (this.dataObj != null) {
            result.put("data", this.dataObj);
        } else {
            result.put("data", this.data);
        }
        result.put("pageDto", this.pageDto);
        result.put("msg", this.errorMsg);
        return result;
    }
}

