/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2014 All Rights Reserved.
 */
package com.baijia.tianxiao.util.response;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dto.AppBaseResponse;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.json.JacksonUtil;

/**
 * @author wangzhigang
 * @version 1.0
 * @title ResponseUtil
 * @desc TODO
 * @date 2014年11月3日
 */
public class ResponseUtil {

    private static final Logger logger = LoggerFactory.getLogger(ResponseUtil.class);

    public static void write(HttpServletResponse response, Object data) {
        response.setCharacterEncoding("UTF-8");
        OutputStream os = null;
        try {
            os = response.getOutputStream();
            JacksonUtil.writeObj(os, data);
        } catch (Exception e) {
            logger.error("write exception - ", e);
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    logger.error("close os exception - ", e);
                }
            }
        }
    }

    public static void handleError(final AppBaseResponse resposne, CallService callService) {
        try {
            callService.excute();
        } catch (BussinessException e) {
            resposne.setCode(TianXiaoConstant.ERRO_CODE);
            resposne.setMsg(e.getMessage());
            logger.error("BussinessException is {}", e);
        } catch (Exception e) {
            resposne.setCode(TianXiaoConstant.ERRO_CODE);
            resposne.setMsg(e.getMessage());
            logger.error("Exception is {}", e);
        }
    }

    /**
     * 用于302之前添加cookie进行跨域请求
     * 
     * @param response
     * @param redirectUrl
     */
    public static void sendRedirectWithCookie(HttpServletResponse response, String redirectUrl, Cookie cookie) {
        response.addCookie(cookie);
        String htmlScript =
            "<html><body><script type='text/javascript'>location.href='" + redirectUrl + "';</script></body></html>";
        try {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            response.getWriter().write(htmlScript);
            response.getWriter().flush();
        } catch (Exception e) {
            ResponseUtil.write(response, "绑定学员失败");
        }
    }

    public static interface CallService {
        void excute();
    }
}
