/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.exception;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;


/**   
 * @Title       : ParameterException 
 * @Description : 参数异常
 * @Author      : zhenyujian
 * @Date        : 2015年12月1日 下午2:43:58 
 */
public class ParameterException extends CustomException {

	private static final long serialVersionUID = 2538710466693296094L;
	
	private static final UniverseErrorCode DEFAULT_ERRORCODE = CommonErrorCode.PARAM_ERROR;
    
    
    public ParameterException(UniverseErrorCode errorCode) {
        this.errorCode = errorCode;
    }
    
    public ParameterException(String message) {
    	this.errorCode = DEFAULT_ERRORCODE;
        this.message = message;
    }
    
    public ParameterException(UniverseErrorCode errorCode, String message) {
        this.message = message;
        this.errorCode = errorCode;
    }
    
    public ParameterException(){
    	this.errorCode = DEFAULT_ERRORCODE;
    }
}




