package com.baijia.tianxiao.excel;

import java.text.SimpleDateFormat;
import java.util.Date;

public class ExcelUtils {

    public static ExcelCell createExcelMoney(Double value) {
        return createExcelMoney(value, "￥");
    }

    public static ExcelCell createExcelMoney(Double value, String prefix) {
        if (value == null) {
            value = 0d;
        }
        if (prefix == null) {
            prefix = "";
        }
        return new ExcelCell(prefix + value);
    }

    public static ExcelCell createExcelInteger(Integer value) {
        return createExcelInteger(value, 0);
    }

    public static ExcelCell createExcelInteger(Integer value, Integer defValue) {
        if (value == null) {
            return new ExcelCell(defValue);
        }
        return new ExcelCell(value);
    }

    public static ExcelCell createExcelDate(Date value, String format) {
        return createExcelDate(value, new SimpleDateFormat(format));
    }

    public static ExcelCell createExcelDate(Date value, SimpleDateFormat sdf) {
        if (value == null) {
            return new ExcelCell(null);
        }
        return new ExcelCell(sdf.format(value));
    }
}
