
/**
<<<<<<< HEAD
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
=======
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
>>>>>>> s_2_18
 */

package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;

public enum ErpErrorCode implements UniverseErrorCode {

    UNKNOW(ErrorSide.UNKNOW, Subsystem.UNKNOW, Platform.UNKNOW, 1, "未知类型错误"),

    MODIFY_SIGNUP_STATUS_ERROR(1002, "咨询用户不存在"),

    TEACHER_HAS_CLASS_RECORD(1000, "当前待清除数据中存在有上课记录的老师,无法删除"),
    ALL_TEACHER_HAS_CLASS_RECORD(1001, "当前待清除数据中所有老师都有上课记录的老师,无法删除"),

    ;

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private ErpErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    private ErpErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.ORGANIZATION, Platform.PC, code, msg);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public UniverseErrorCode fromCode(int code) {
        for (ErpErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return UNKNOW;
    }

}
