package com.baijia.tianxiao.dto;

import java.io.Serializable;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ErrorCodeUtil;

import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode
@Data
public class WebResponse<T> implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 218412192938273843L;
    private long code;
    private String msg;
    private T data;
    private PageDto pageDto;

    /**
     * 状态码为0，即请求成功，给成功数据
     * 
     * @param
     */
    public WebResponse() {
        this.code = 0;
    }

    public WebResponse(T data) {
        this.code = 0;
        this.data = data;
    }

    public WebResponse(T data,PageDto pageDto) {
        this.code = 0;
        this.data = data;
        this.pageDto=pageDto;
    }

    /**
     * 请求错误，通过错误码定义错误
     * 
     * @param errorCode
     */
    public WebResponse(UniverseErrorCode errorCode) {
        this.code = ErrorCodeUtil.getUniverseErrorCode(errorCode);
        this.msg = errorCode.getMessage();
    }

    /**
     * 请求错误，通过错误码和自定义的错误信息来定义返回结果
     * 
     * @param errorCode
     * @param msg
     */
    public WebResponse(UniverseErrorCode errorCode, String msg) {
        this.code = ErrorCodeUtil.getUniverseErrorCode(errorCode);
        this.msg = msg;
    }

    public void setErrorCode(UniverseErrorCode errorCode, String msg) {
        this.code = ErrorCodeUtil.getUniverseErrorCode(errorCode);
        this.msg = msg;
    }

    public void setErrorCode(UniverseErrorCode errorCode) {
        this.code = ErrorCodeUtil.getUniverseErrorCode(errorCode);
        if (errorCode != null) {
            this.msg = errorCode.getMessage();
        }
    }

    public long getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public T getData() {
        return data;
    }

}
