
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.constants.sms;

import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

/**
 * @title TxSmsCodeType
 * @desc TODO 
 * @author caoliang
 * @date 2016年4月20日
 * @version 1.0
 */

public enum TxSmsCodeType {
    
    APPLY(1,"申请试用天校","验证码{{code}}（申请试用天校），请注意保密并及时填写。感谢您对天校的支持，咨询电话4000-910-910。", "_TX_APPLY_KEY_"),
    SAVE_PAY_PWD(2,"设置支付密码","验证码{{code}}(设置支付密码)，请注意保密并及时填写。感谢您对天校的支持，咨询电话4000-910-910。","_TX_SAVE_PAY_PWD_KEY_"),
    INVITE_TOBE_CAMPUS(3,"邀请为分校区","验证码{{code}}(分校区)，请注意保密并及时填写。感谢您对天校的支持，咨询电话4000-910-910。","_TX_INVITE_TOBE_CAMPUS_KEY_"),
    MOD_ORG_MOBILE(4,"修改主账户手机号","验证码{{code}}(修改手机号码)，请注意保密并及时填写。感谢您对天校的支持，咨询电话4000-910-910。","_TX_MOD_ORG_MOBILE_KEY_"),
    NEW_ORG_PWD(4,"浅注册密码短信","密码{{code}}，请注意保密并及时修改。感谢您对天校的支持，咨询电话4000-910-910。","_TX_NEW_ORG_PWD_KEY_"),
    NEW_CASCADE_PWD(4," 邀请为子帐号","密码{{code}}，请注意保密并及时修改。感谢您对天校的支持，咨询电话4000-910-910。","_TX_NEW_ORG_PWD_KEY_"),
    VZHIBO_CONSULT_MOBILE_KEY(5,"微直播发言，验证手机号","验证码{{code}}，请注意保密并及时修改。感谢您对天校的支持，咨询电话4000-910-910。","_VZHIBO_CONSULT_MOBILE_KEY_"),
    ;
    
    private Integer code;
    private String label;
    private String msg;
    private String cacheKey;
    
    private static Map<String, TxSmsCodeType> noLogin = Maps.newHashMap();
    static{
        noLogin.put(APPLY.code.toString(), APPLY);
        noLogin.put(VZHIBO_CONSULT_MOBILE_KEY.code.toString(), VZHIBO_CONSULT_MOBILE_KEY);
    }
    
    
    TxSmsCodeType(Integer code, String label, String msg, String cacheKey){
        this.code = code;
        this.label = label;
        this.msg = msg;
        this.cacheKey = cacheKey;
    }

    public Integer getCode() {
    
        return code;
    }

    public void setCode(Integer code) {
    
        this.code = code;
    }

    public String getLabel() {
    
        return label;
    }

    public void setLabel(String label) {
    
        this.label = label;
    }
    
    public String getMsg() {
    
        return msg;
    }

    public void setMsg(String msg) {
    
        this.msg = msg;
    }

    public String getCacheKey() {
    
        return cacheKey;
    }

    public void setCacheKey(String cacheKey) {
    
        this.cacheKey = cacheKey;
    }

    public static boolean isTypeValid(String type){
        boolean result = false;
        if(StringUtils.isNotBlank(type)){
            for(TxSmsCodeType codeType : TxSmsCodeType.values()){
                if(codeType.getCode().toString().equals(type)){
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
    
    public static TxSmsCodeType getTxSmsCodeType(String type){
        TxSmsCodeType smsCodeType = null;
        if(StringUtils.isNotBlank(type)){
            for(TxSmsCodeType codeType : TxSmsCodeType.values()){
                if(codeType.getCode().toString().equals(type)){
                    smsCodeType = codeType;
                    break;
                }
            }
        }
        return smsCodeType;
    }
    
    public static String getSmsMsg(TxSmsCodeType codeType, String code){
        return codeType.msg.replace("{{code}}", code);
    }
    
    public static boolean noLogin(String type){
        return noLogin.containsKey(type);
    }
    
}

    