
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.util;



import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author zhangbing
 * @version 1.0
 * @title StringUtils
 * @desc TODO
 * @date 2016年3月23日
 */

public class StringUtils {
    private final static BigDecimal MILLION = new BigDecimal("100000");
    private final static BigDecimal TEN_THOUSAND = new BigDecimal("10000");
    private final static BigDecimal BILLION = new BigDecimal("1000000000");

    /**
     * 判断字符串str中是否只包含字母和汉字、数字
     *
     * @return
     */
    public static boolean hanziAndLetterValidate(String str) {
        String regex = "[0-9a-zA-Z\u4e00-\u9fa5]*";
        return str.matches(regex);
    }

    /**
     * 判断字符串str中是否只包含数组
     *
     * @return
     */
    public static boolean numberValidate(String str) {
        String regex = "^([0-9])+$";
        return str.matches(regex);
    }

    /**
     * 判断字符串str中是否只包含数组
     *
     * @return
     */
    public static boolean letterValidate(String str) {
        String regex = "^([a-zA-Z])+$";
        return str.matches(regex);
    }

    public static String formatNumber(BigDecimal number) {
        if (number == null) {
            return "0.00";
        }
        if (number.compareTo(BILLION) >= 0) {
            return "99,999.9万+";
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);//设置小数点后面允许多少位
        numberFormat.setGroupingUsed(true);//设置分组如：,
        if (number.compareTo(MILLION) >= 0) {
            BigDecimal tmp = number.divide(TEN_THOUSAND, 1, BigDecimal.ROUND_HALF_UP);
            numberFormat.setMinimumFractionDigits(1);
            return numberFormat.format(tmp.doubleValue()) + "万";
        }
        return numberFormat.format(number.doubleValue());
    }

    public static String formatNumber(Number num, int scala) {
        if (num == null) {
            return "0.00";
        }
        BigDecimal number = new BigDecimal(num.doubleValue());
        if (number.compareTo(BILLION) >= 0) {
            return "99,999.9万+";
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);//设置分组如：,
        if (number.compareTo(MILLION) >= 0) {
            BigDecimal tmp = number.divide(TEN_THOUSAND, 1, BigDecimal.ROUND_HALF_UP);
            numberFormat.setMinimumFractionDigits(1);
            return numberFormat.format(tmp.doubleValue()) + "万";
        }
        numberFormat.setMinimumFractionDigits(scala);
        return numberFormat.format(number.doubleValue());
    }

    /**
     * 删除html格式
     *
     * @param htmlStr
     * @return
     */
    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>"; //定义script的正则表达式
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>"; //定义style的正则表达式
        String regEx_html = "<[^>]+>"; //定义HTML标签的正则表达式

        Pattern p_script = Pattern.compile(regEx_script, Pattern.CASE_INSENSITIVE);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll(""); //过滤script标签

        Pattern p_style = Pattern.compile(regEx_style, Pattern.CASE_INSENSITIVE);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll(""); //过滤style标签

        Pattern p_html = Pattern.compile(regEx_html, Pattern.CASE_INSENSITIVE);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll(""); //过滤html标签

        return htmlStr.trim(); //返回文本字符串
    }

    public static String imgToHttps(String url) {
        if (url == null) {
            return "";
        }
        return url.replaceFirst("http://img.gsxservice.com", "https://imgs.genshuixue.com");
    }

    public static void main(String[] args) {

    }
}

    