package com.baijia.tianxiao.util;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

/**
 * Created by liuxp on 16/12/12.
 */

@Slf4j
public class CollectionHelper {
    public static <T> Map<Long,T> toIdMap(Collection<T> collection){
        return toKeyMap(collection,"id");
    }

    public static <T> Map<Long,T> toKeyMap(Collection<T> collection, final String key){
        return CollectionUtils.extractMap(collection, new CollectionUtils.Extracter<Long, T>() {
            @Override
            public Long extract(T t) {
                try {
                    Field field = t.getClass().getDeclaredField(key);
                    field.setAccessible(true);
                    Long value = (Long) field.get(t);
                    return value;
                } catch (NoSuchFieldException e) {
                    log.error("ToKeyMap exception ", e);
                } catch (IllegalAccessException e) {
                    log.error("ToKeyMap exception ", e);
                }
                throw new RuntimeException("ToKeyMap exception");
            }
        });
    }

    public static <T> String join(Collection<T> collection){
        if(collection==null || collection.size()<1){
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T t:collection){
            sb.append(",").append(t.toString());
        }
        return sb.substring(1);
    }
}
