package com.baijia.tianxiao.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.constants.LoginConstant;
import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;

import lombok.extern.slf4j.Slf4j;

/**
 * @title WrapLoginFilter
 * @desc TODO
 * @author caoliang
 * @date 2016年3月16日
 * @version 1.0
 */
@Slf4j
public class WrapLoginFilter implements Filter {

    private static final String DEFAULT_COOKIE_NAME = "ORG_AUTH_TOKEN";
    private static final String TOKEN_FROM_COOKIERS_URL = "tokenFromCookiesUrl";

    private FilterConfig filterConfig;

    private List<String> tokenFromCookiesUrl = new ArrayList<>();

    @Override
    public final void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse,
        final FilterChain filterChain) throws IOException, ServletException {
        final HttpServletRequest request = (HttpServletRequest) servletRequest;
        final HttpSession session = request.getSession();
        boolean hasInit = false;
        AppAuthToken token = null;
        if (session.getAttribute(LoginConstant.TX_PC_LOGIN_ATTRIBUTE_NAME) != null) {
            hasInit = true;
            token = (AppAuthToken) session.getAttribute(LoginConstant.TX_PC_LOGIN_ATTRIBUTE_NAME);
        }

        String path = request.getRequestURI().substring(request.getContextPath().length());
        log.info(" Request Path : {} ", path);
        if (!hasInit && tokenFromCookiesUrl.contains(path)) {
            token = initTokenFromCookie(request);
        }

        initPCContext(token);
        try {
            filterChain.doFilter(request, servletResponse);
        } finally {
            TianxiaoPCContext.clear();
        }
    }

    private void initPCContext(AppAuthToken token) {
        if (token == null) {
            return;
        }
        TianxiaoPCContext.setAppAuthToken(token);
        log.debug("tx token：{}", token);
        TianxiaoPCContext.setOrgId(token.getUser_id().intValue());
        TianxiaoPCContext.setTXCascadeId(token.getTx_cascade_user_id());
        TianxiaoPCContext.setTXLoginAccountId(token.getTx_account_id());
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */

    private AppAuthToken initTokenFromCookie(HttpServletRequest request)
        throws JsonParseException, JsonMappingException, IOException {
        // 从cookie找
        String encryptedToken = retrieveCookieValue(request);
        if (StringUtils.isNotBlank(encryptedToken)) {
            return JacksonUtil.str2Obj(EncryptUtils.strDecode(encryptedToken), AppAuthToken.class);
        }
        return null;
    }

    private String retrieveCookieValue(final HttpServletRequest request) {
        final Cookie cookie = org.springframework.web.util.WebUtils.getCookie(request, DEFAULT_COOKIE_NAME);
        if (log.isDebugEnabled()) {
            log.info("get token from cookie | cookieName:{}, cookie value:{}", DEFAULT_COOKIE_NAME,
                cookie == null ? null : cookie.getValue());

        }
        return cookie == null ? null : cookie.getValue();
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String initParameter = this.filterConfig.getInitParameter(TOKEN_FROM_COOKIERS_URL);
        if (GenericsUtils.notNullAndEmpty(initParameter)) {
            String[] urls = initParameter.split("[, ]+");
            this.tokenFromCookiesUrl.addAll(Arrays.asList(urls));
        }
    }

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        String token =
            "KHsidXNlcl9pZCI6NjI3ODgsImN0IjoxNDg5MDQ4ODcxLCJzYWx0IjojMnhPOjloeUQjLSN1eWBkYnRkYmVmYHZ0ZnNgamUjO292bW0tI3V5YWNlZXF3cHZha2YkPHB3bm4uJHZ6YXhrdWt2cXRha2YkPHB3bm4uJGRmZnJ4cXdZaHV2bHJxJT0zLyVkc3NIcXklPSV3aHZ3JS8ld3tpdXJxY3N2a2NtaCY-OjY7PDwwJmNKdnNxY3Fld3hpdiY-Nzs3PIE";
        System.out.println(EncryptUtils.strDecode(token));
        AppAuthToken str2Obj = JacksonUtil.str2Obj(EncryptUtils.strDecode(token), AppAuthToken.class);
        System.out.println(str2Obj);

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.servlet.Filter#destroy()
     */

    @Override
    public void destroy() {

    }
}
