
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.constants.org;

/**
 * @title BizConf
 * @desc TODO 这个应该是网校的配置信息,建议换个类名
 * @author zhangbing
 * @date 2015年12月7日
 * @version 1.0
 */
public class BizConf {
    
    /**
     * hag 小流量 新白名单
     */
    public static final int DEFAULT_TYPE = 0;

    // 天校机构白名单
    public static final String HAG_RESOURSE_ORG_TIANXIAO_NUMBER = "jigou_tianxiao_orgNumber";

    //最多推荐课程数
    public static final Integer MAX_RECOMMEND_COURSE_COUNT = 10;
    
    //艺体模板中最多显示10门分类
    public static final Integer MAX_SUBJECT_DISPLAY = 10; 
    
    //自定义课程最多取3个
    public static final Integer MAX_COURSE_GROUP = 3;

    // 每个分类下最多显示4门课程
    public static final Integer MAX_COURSE_DISPLAY = 4;

    public static final Integer TRUE = 1;

    public static final Integer FALSE = 0;

    // 400主机号码
    public static final String _400_PHONE_PREFIX = "4000122166";

    // 关于我们
    public static final String ABOUT_US = "{host1}/org/intro/{number}";

    // 课程链接
    public static final String ORG_COURSE_LINK = "{host}/course/{number}";

    // 老师列表
    public static final String ORG_TEACHER_LINK = "{host}/teacher/{number}";

    // 评价列表、学员之声
    public static final String ORG_COMMENT_LINK = "{host1}/org/comment/{number}";

    // 校区地址
    public static final String ORG_BRANCH_LINK = "{host}/branch/{number}";

    // 3810课程详情页地址:{number}：课程编号
    public static final String ORG_COURSE_DETAIL = "{host}/course/detail/{number}";

    // 班课地址详情页:课程编号
    public static final String CLASS_COURSE_DETAIL = "{host1}/teacher/classCourseDetail/{number}";

    // 优惠券链接地址
    public static final String ORG_COUPON_LINK = "{host1}/org/couponList?number={number}";

    // 相册
    public static final String ORG_PHOTO_LINK = "{host}/photo/{number}";

    // 活动通知黑板报详情页
    public static final String ORG_ACTIVITY_BLACKBOARD_LINK = "{host1}/org/blackDetail?board_id={id}";

    // 普通黑板报详情
    public static final String ORG_BLACKBOARD_LINK = "{host1}/org/activityDetail?board_id={id}";

    // 机构m站简介、评价、相册、校区链接
    public static final String ORG_INFO_LINKS =
        "{\"brief\":\"host/org/intro/number\",\"comment\":\"host/org/comment/number\",\"album\":\"host/org/photo/number\",\"branch\":\"host/org/area/number\"}";

    // 钢琴图片地址
    public static final String PIANO_LINK =
        "https://imgs.genshuixue.com/4672243_12o0f9ef.png@1e_2290w_1c_0i_1o_90Q_1x.png";

    // 小提琴图片地址
    public static final String VIOLIN_LINK =
        "https://imgs.genshuixue.com/4672250_52r12vr4.png@1e_2290w_1c_0i_1o_90Q_1x.png";

    // 吉他图片地址
    public static final String GUITAR_LINK =
        "https://imgs.genshuixue.com/4672265_vyh6n0o7.png@1e_2290w_1c_0i_1o_90Q_1x.png";

    // 声乐图片地址
    public static final String VOCALITY_LINK =
        "https://imgs.genshuixue.com/4672254_erqgnw5b.png@1e_2290w_1c_0i_1o_90Q_1x.png";

    public static final String[] PHOTO_LINKS = new String[] { PIANO_LINK, VIOLIN_LINK, GUITAR_LINK, VOCALITY_LINK };

    public static final String DEFAULT_LOGO_URL = "https://imgs.genshuixue.com/13699255_id1fpdgb.jpg";

    public static final String DEFAULT_HEAD_URL="";
    
    //机构设备是否接收push消息的开关
    public static final String ORG_DEVICE_PUSH_SWITCH = "org_device_push_switch";
    
    // 天校体验账户
    public static final String HAG_RESOURSE_TIANXIAO_TRIAL_ACCOUNT = "tianxiao_trial_account";

    // 普通帐号
    public static final int NORMAL_ACCOUNT = 0;
    // 体验
    public static final int EXPERIENCE_ACCOUNT = 1;

    // 天校微直播白名单
    public static final String LIVE_TIANXIAO_ORGNUMBER = "live_tianxiao_orgNumber";
    
}
