/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import java.math.BigDecimal;

public class ArithUtil {
    private static final int DEF_DIV_SCALE = 2;

    private ArithUtil() {
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return ArithUtil.div(v1, v2, 2);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static int compareTo(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.compareTo(b2);
    }

    public static void main(String[] args) {
        double v1 = 0.0;
        double v2 = 0.0;
        System.out.println(v1 + ":" + v2);
        System.out.println(ArithUtil.compareTo(v1, v2));
        v1 = 0.1;
        System.out.println(v2 + ":" + v1);
        System.out.println(ArithUtil.compareTo(v2, v1));
        double d = ArithUtil.round(5.0, 1);
        System.out.println(d);
        Long ddd = 4L;
        System.out.print(ArithUtil.div(ddd.longValue(), 100.0, 2));
    }
}

