/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

public enum OrgErrorCode implements UniverseErrorCode
{
    UNKNOW(ErrorSide.UNKNOW, Subsystem.UNKNOW, Platform.UNKNOW, 1, "\u672a\u77e5\u7c7b\u578b\u9519\u8bef"),
    USER_NOT_FOUND(1100, "\u7528\u6237\u4e0d\u5b58\u5728"),
    TEMPLATE_NOT_EXISTS(1101, "\u6a21\u677f\u4e0d\u5b58\u5728"),
    NO_TEMPLATE_SELECTED(1102, "\u6ca1\u6709\u9009\u62e9\u6a21\u677f"),
    NO_SUBJECT_FOR_REQ(1103, "\u8bfe\u7a0b\u5206\u7c7b\u4e0d\u5b58\u5728"),
    COURSE_HAS_BEEN_GROUPED(1104, "\u8be5\u8bfe\u7a0b\u5df2\u5206\u7c7b"),
    COURSE_GROUP_NAME_OVERLENGTH(1105, "\u8bfe\u7a0b\u5206\u7ec4\u540d\u79f0\u957f\u5ea6\u8d85\u8fc7\u9650\u5236"),
    COURSE_GROUP_NAME_EXISTS(1106, "\u8bfe\u7a0b\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728"),
    ORG_NOT_EXISTS(1107, "\u673a\u6784\u4e0d\u5b58\u5728"),
    GET_ORG_INFO_FAILED(1108, "\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u5931\u8d25"),
    ORG_INFO_PHOTO_SIZE(1109, "APP\u6700\u591a\u4e0a\u4f2050\u5f20\u7167\u7247"),
    ORG_INFO_PHOTO_ID(1110, "\u56fe\u7247\u4e0a\u4f20id\u9519\u8bef"),
    ORG_NOT_BIND_WECHAT(1111, "\u4e3b\u6821\u533a\u673a\u6784\u672a\u7ed1\u5b9a\u5fae\u4fe1\u516c\u4f17\u53f7,\u65e0\u6cd5\u5c06\u5206\u6821\u533a\u7eb3\u5165\u7edf\u4e00\u516c\u4f17\u53f7\u7ba1\u7406"),
    ORG_STILL_BIND_WECHAT(1112, "\u5206\u6821\u533a\u673a\u6784\u5f53\u524d\u5df2\u7ed1\u5b9a\u516c\u4f17\u53f7,\u8bf7\u8054\u7cfb\u6821\u533a\u89e3\u7ed1\u516c\u4f17\u53f7\u540e\u624d\u53ef\u4ee5\u7eb3\u5165\u5171\u7528\u516c\u4f17\u53f7");

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private OrgErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    private OrgErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.ORGANIZATION, Platform.PC, code, msg);
    }

    @Override
    public ErrorSide getErrorSide() {
        return this.errorSide;
    }

    @Override
    public Subsystem getSystem() {
        return this.subsystem;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public OrgErrorCode fromCode(int code) {
        for (OrgErrorCode errorCode : OrgErrorCode.values()) {
            if (errorCode.getSubsystemErrorCode() != code) continue;
            return errorCode;
        }
        return UNKNOW;
    }
}

