/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

public enum ErpErrorCode implements UniverseErrorCode
{
    UNKNOW(ErrorSide.UNKNOW, Subsystem.UNKNOW, Platform.UNKNOW, 1, "\u672a\u77e5\u7c7b\u578b\u9519\u8bef"),
    MODIFY_SIGNUP_STATUS_ERROR(1002, "\u54a8\u8be2\u7528\u6237\u4e0d\u5b58\u5728");

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private ErpErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    private ErpErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.ORGANIZATION, Platform.PC, code, msg);
    }

    @Override
    public ErrorSide getErrorSide() {
        return this.errorSide;
    }

    @Override
    public Subsystem getSystem() {
        return this.subsystem;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ErpErrorCode fromCode(int code) {
        for (ErpErrorCode errorCode : ErpErrorCode.values()) {
            if (errorCode.getSubsystemErrorCode() != code) continue;
            return errorCode;
        }
        return UNKNOW;
    }
}

