/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.beanCopy;

import com.baijia.tianxiao.beanCopy.defaultTypeConverter.Long2DataConverter;
import com.baijia.tianxiao.beanCopy.defaultTypeConverter.Str2NumberConverter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Typeconverter {
    private static final List<Typeconverter> defaultConverters = Arrays.asList(new Long2DataConverter(), new Str2NumberConverter());

    public final Object superConvert(String fieldName, Type sourceFieldType, Type destFieldType, Object value) {
        if (value == null || sourceFieldType == destFieldType) {
            return value;
        }
        Collection<Typeconverter> convterters = this.getConvterters();
        Object retValue = null;
        retValue = this.convert(fieldName, sourceFieldType, destFieldType, value);
        if (retValue != null && !retValue.equals(value)) {
            return retValue;
        }
        for (Typeconverter typeConvterter : convterters) {
            retValue = typeConvterter.convert(fieldName, sourceFieldType, destFieldType, value);
            if (retValue == null || retValue.equals(value)) continue;
            return retValue;
        }
        return value;
    }

    public abstract Object convert(String var1, Type var2, Type var3, Object var4);

    public void checkConvertTypes(Type sourceFieldType, Type destFieldType) {
        if (sourceFieldType == null) {
            throw new IllegalArgumentException(String.format("sourceFieldType :%s is null ,can not complete convert ", new Object[0]));
        }
        if (destFieldType == null) {
            throw new IllegalArgumentException(String.format("destFieldType :%s is null ,can not complete convert ", new Object[0]));
        }
    }

    protected Collection<Typeconverter> getConvterters() {
        return Collections.unmodifiableCollection(defaultConverters);
    }
}

