/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.beanCopy;

import com.baijia.tianxiao.beanCopy.AnnotationDescMaker;
import com.baijia.tianxiao.beanCopy.ByteSourceClassLoader;
import com.baijia.tianxiao.beanCopy.Invoker;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerCreateor
implements Opcodes {
    private static final Logger log = LoggerFactory.getLogger(InvokerCreateor.class);

    public static <T> Invoker<T> createInvoker(Method method) {
        Class<?> hostClass = method.getDeclaringClass();
        String className = InvokerCreateor.getInvokerClassName(hostClass, method);
        byte[] generatorClass = InvokerCreateor.generatorClass(className, method.getDeclaringClass(), method);
        Class<?> invokerClass = ByteSourceClassLoader.loadClass(InvokerCreateor.class.getClassLoader(), className, generatorClass);
        try {
            return (Invoker)invokerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getInvokerClassName(Class<?> hostClass, Method method) {
        return hostClass.getName() + "$" + method.getName() + "$" + Math.abs(Type.getMethodDescriptor((Method)method).hashCode());
    }

    public static byte[] generatorClass(Class<?> hostClass, Method method) {
        return InvokerCreateor.generatorClass(InvokerCreateor.getInvokerClassName(hostClass, method), hostClass, method);
    }

    public static byte[] generatorClass(String invokerClassName, Class<?> hostClass, Method method) {
        String hostClassDesc = Type.getDescriptor(hostClass);
        String hostClassInnerName = Type.getInternalName(hostClass);
        String className = GenericsUtils.isNullOrEmpty(invokerClassName) ? hostClass.getName() + "$" + method.getName() + "$" + Math.abs(Type.getMethodDescriptor((Method)method).hashCode()) : invokerClassName;
        className = className.replace(".", "/");
        Class<?> returnType = method.getReturnType();
        log.debug("retType : {} " + returnType.getName());
        boolean primitive = returnType.isPrimitive();
        boolean hasRet = returnType != Void.TYPE;
        log.debug("has ret : " + hasRet);
        ClassWriter cw = new ClassWriter(2);
        CheckClassAdapter cca = new CheckClassAdapter((ClassVisitor)cw);
        TraceClassVisitor cv = new TraceClassVisitor((ClassVisitor)cca, new PrintWriter(System.out));
        cv.visit(51, 33, className, AnnotationDescMaker.makeAnnotatinDesc(new AnnotationDescMaker.AnnotationWrapper(Type.getDescriptor(Invoker.class), hostClassDesc)), Type.getInternalName(Object.class), new String[]{Type.getInternalName(Invoker.class)});
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cv.visitMethod(129, "invoke", "(" + hostClassDesc + "[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (hasRet) {
            log.debug("has ret ");
            InvokerCreateor.visitWithHasRet(mv, method.getParameterTypes(), method, className, hostClassDesc, hostClassInnerName, returnType, primitive);
        } else {
            log.debug("has no ret");
            InvokerCreateor.visitWithNotRet(mv, method.getParameterTypes(), method, className, hostClassDesc, hostClassInnerName, returnType, primitive);
        }
        mv = cv.visitMethod(4289, "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, hostClassInnerName);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, className, "invoke", "(" + hostClassDesc + "[Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        cv.visitEnd();
        return cw.toByteArray();
    }

    private static void visitWithNotRet(MethodVisitor mv, Class<?>[] argumentTypes, Method method, String className, String hostClassDesc, String hostClassInnerName, Class<?> returnType, boolean primitive) {
        boolean hasArguments = argumentTypes.length > 0;
        int oldBaseIndex = 2;
        int baseIndex = 2;
        if (hasArguments) {
            int i = 0;
            for (Class<?> arguType : argumentTypes) {
                log.debug("arguType:" + arguType.getName() + "i : " + i);
                Label label = new Label();
                String innnerName = Type.getInternalName(InvokerCreateor.getWrapperType(arguType));
                mv.visitLabel(label);
                mv.visitVarInsn(25, 2);
                log.debug("i:" + i);
                if (i < 6) {
                    mv.visitInsn(InvokerCreateor.getICONST(i));
                } else {
                    mv.visitIntInsn(16, i);
                }
                mv.visitInsn(50);
                mv.visitTypeInsn(192, innnerName);
                mv.visitVarInsn(58, ++baseIndex);
                ++i;
            }
        }
        log.debug("baseIndex : " + baseIndex);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        if (hasArguments) {
            for (int i = oldBaseIndex + 1; i <= baseIndex; ++i) {
                mv.visitVarInsn(25, i);
                if (!argumentTypes[i - oldBaseIndex - 1].isPrimitive()) continue;
                InvokerCreateor.wrapperChange(mv, InvokerCreateor.getWrapperType(argumentTypes[i - oldBaseIndex - 1]));
            }
        }
        log.debug("==========");
        mv.visitMethodInsn(182, hostClassInnerName, method.getName(), Type.getMethodDescriptor((Method)method));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(1);
        mv.visitInsn(176);
        Label l2 = new Label();
        mv.visitLabel(l2);
        if (hasArguments) {
            log.debug("maxStack: " + (1 + argumentTypes.length) + " , maxLocal" + (3 + argumentTypes.length));
            mv.visitMaxs(1 + argumentTypes.length, 3 + argumentTypes.length);
        } else {
            mv.visitMaxs(1, 3);
        }
        mv.visitEnd();
    }

    private static void visitWithHasRet(MethodVisitor mv, Class<?>[] argumentTypes, Method method, String className, String hostClassDesc, String hostClassInnerName, Class<?> returnType, boolean primitive) {
        int i;
        boolean hasArguments = argumentTypes.length > 0;
        int oldBaseIndex = 2;
        int baseIndex = 2;
        log.debug("arguType are : " + argumentTypes.length);
        if (hasArguments) {
            int i2 = 0;
            for (Class<?> arguType : argumentTypes) {
                log.debug("arguType:" + arguType.getName() + "i : " + i2);
                Label label = new Label();
                String innnerName = Type.getInternalName(InvokerCreateor.getWrapperType(arguType));
                mv.visitLabel(label);
                mv.visitVarInsn(25, 2);
                if (i2 < 6) {
                    mv.visitInsn(InvokerCreateor.getICONST(i2));
                } else {
                    mv.visitIntInsn(16, i2);
                }
                mv.visitInsn(50);
                mv.visitTypeInsn(192, innnerName);
                mv.visitVarInsn(58, ++baseIndex);
                ++i2;
            }
        }
        log.debug("baseIndex is : " + baseIndex);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        if (hasArguments) {
            for (i = oldBaseIndex + 1; i <= baseIndex; ++i) {
                mv.visitVarInsn(25, i);
                if (!argumentTypes[i - oldBaseIndex - 1].isPrimitive()) continue;
                InvokerCreateor.wrapperChange(mv, InvokerCreateor.getWrapperType(argumentTypes[i - oldBaseIndex - 1]));
            }
        }
        mv.visitMethodInsn(182, hostClassInnerName, method.getName(), Type.getMethodDescriptor((Method)method));
        if (primitive) {
            InvokerCreateor.primitiveChange(mv, returnType);
        }
        mv.visitVarInsn(58, i);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(25, i);
        mv.visitInsn(176);
        Label l2 = new Label();
        mv.visitLabel(l2);
        if (hasArguments) {
            mv.visitMaxs(1 + argumentTypes.length, 4 + argumentTypes.length);
        } else {
            mv.visitMaxs(1, 4);
        }
        mv.visitEnd();
    }

    private static int getICONST(int i) {
        switch (i) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
        }
        return 0;
    }

    public static void wrapperChange(MethodVisitor mv, Class<?> wrapperType) {
        Method primitiveMethod = InvokerCreateor.getPrimitiveMethod(InvokerCreateor.getWrapperType(wrapperType));
        mv.visitMethodInsn(182, Type.getInternalName(wrapperType), primitiveMethod.getName(), Type.getMethodDescriptor((Method)primitiveMethod));
    }

    private static Method getPrimitiveMethod(Class<?> wrapperType) {
        String methodName = "";
        Class[] emptyParamterTypes = new Class[]{};
        if (wrapperType == Byte.class) {
            methodName = "byteValue";
        } else if (wrapperType == Boolean.class) {
            methodName = "booleanValue";
        } else if (wrapperType == Character.class) {
            methodName = "charValue";
        } else if (wrapperType == Short.class) {
            methodName = "shortValue";
        } else if (wrapperType == Integer.class) {
            methodName = "intValue";
        } else if (wrapperType == Float.class) {
            methodName = "floatValue";
        } else if (wrapperType == Long.class) {
            methodName = "longValue";
        } else if (wrapperType == Double.class) {
            methodName = "doubleValue";
        }
        log.debug("wrapperType : " + wrapperType + " and methodName is : " + methodName);
        try {
            return wrapperType.getMethod(methodName, emptyParamterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void primitiveChange(MethodVisitor mv, Class<?> primitiveType) {
        Method wrapperTypeMethod = InvokerCreateor.getWrapperMethod(primitiveType);
        Class<?> wrapperClass = wrapperTypeMethod.getDeclaringClass();
        log.debug(Type.getInternalName(wrapperClass) + "----" + Type.getMethodDescriptor((Method)wrapperTypeMethod));
        mv.visitMethodInsn(184, Type.getInternalName(wrapperClass), "valueOf", Type.getMethodDescriptor((Method)wrapperTypeMethod));
    }

    private static Method getWrapperMethod(Class<?> primitiveType) {
        Class<?> wrapperType = InvokerCreateor.getWrapperType(primitiveType);
        try {
            return wrapperType.getMethod("valueOf", primitiveType);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class<?> getWrapperType(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        return primitiveType;
    }

    public static int getLoadOpcode(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE || primitiveType == Boolean.TYPE || primitiveType == Short.TYPE || primitiveType == Character.TYPE || primitiveType == Byte.TYPE) {
            return 21;
        }
        if (primitiveType == Long.TYPE) {
            return 22;
        }
        if (primitiveType == Float.TYPE) {
            return 23;
        }
        if (primitiveType == Double.TYPE) {
            return 24;
        }
        return 25;
    }
}

