/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.request;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class RequestUtils {
    public static String getParam(HttpServletRequest request, String name) {
        return RequestUtils.getStringParam(request, name);
    }

    public static String getParam(HttpServletRequest request, String name, String defaultValue) {
        return RequestUtils.getStringParam(request, name, defaultValue);
    }

    public static String getStringParam(HttpServletRequest request, String name) {
        return RequestUtils.getStringParam(request, name, "");
    }

    public static String getStringParam(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value.trim();
    }

    public static String[] getStringParams(HttpServletRequest request, String name, String[] defaultValues) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return defaultValues;
        }
        return values;
    }

    public static int getIntParam(HttpServletRequest request, String name) {
        return RequestUtils.getIntParam(request, name, 0);
    }

    public static int getIntParam(HttpServletRequest request, String name, int defaultValue) {
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        if (!StringUtils.isNumeric((String)(value = value.trim()))) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static byte getByteParam(HttpServletRequest request, String name) {
        return RequestUtils.getByteParam(request, name, (byte)0);
    }

    public static byte getByteParam(HttpServletRequest request, String name, byte defaultValue) {
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        if (!StringUtils.isNumeric((String)(value = value.trim()))) {
            return defaultValue;
        }
        return Byte.parseByte(value);
    }

    public static long getLongParam(HttpServletRequest request, String name) {
        return RequestUtils.getLongParam(request, name, 0L);
    }

    public static long getLongParam(HttpServletRequest request, String name, long defaultValue) {
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        if (!StringUtils.isNumeric((String)(value = value.trim()))) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static String getPostParamTK(HttpServletRequest request, String key) {
        String params = RequestUtils.getPostString(request);
        if (params != null && !params.equals("") && params.indexOf("\"tk\":\"") > 0) {
            params = params.substring(params.indexOf("\"tk\":\"") + 6);
            int len = 0;
            for (int i = 0; i < params.length(); ++i) {
                if (params.charAt(i) != '\"') continue;
                len = i;
                break;
            }
            params = params.substring(0, len);
            return params;
        }
        return null;
    }

    public static String getPostString(HttpServletRequest request) {
        byte[] data = RequestUtils.getPostData(request);
        return new String(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPostData(HttpServletRequest request) {
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = null;
        byte[] EMPTY_BYTES = new byte[]{};
        try {
            bis = new BufferedInputStream((InputStream)request.getInputStream());
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = bis.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = EMPTY_BYTES;
            return byArray;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    return EMPTY_BYTES;
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    return EMPTY_BYTES;
                }
            }
        }
    }

    public static String getServerHttpPath(HttpServletRequest request) {
        String fmt = "%s://%s/";
        return String.format(fmt, "http", request.getServerName());
    }

    public static String getHttpPath(HttpServletRequest request, String relativePath) {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1, relativePath.length());
        }
        String fmt = "%s://%s/%s";
        return String.format(fmt, "http", request.getServerName(), relativePath);
    }
}

