/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.httpclient;

import com.baijia.commons.lang.utils.file.FileUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    public static final String CHARSET = "UTF-8";

    public static CloseableHttpClient getHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(35000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static CloseableHttpClient getHttpClient(int timeOut) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeOut).setSocketTimeout(timeOut).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static String doGet(String url, Map<String, String> params) {
        return HttpClientUtils.doGet(url, params, CHARSET);
    }

    public static String doPost(String url, Map<String, String> params) {
        return HttpClientUtils.doPost(url, params, CHARSET);
    }

    public static String doGet(String url, Map<String, String> params, String charset) {
        return HttpClientUtils.doGet(url, params, charset, null);
    }

    public static String doGet(String url, Map<String, String> params, String charset, Collection<Header> headers) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry entry : params.entrySet()) {
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair((String)entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            HttpGet httpGet = new HttpGet(url);
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpGet.addHeader(header);
                }
            }
            return HttpClientUtils.execute(null, (HttpUriRequest)httpGet, charset, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPost(String url, Map<String, String> params, String charset) {
        return HttpClientUtils.doPost(url, params, charset, null);
    }

    public static String doPost(String url, Map<String, String> params, String charset, Collection<Header> headers) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            HttpPost httpPost = new HttpPost(url);
            if (pairs != null && pairs.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
            }
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpPost.addHeader(header);
                }
            }
            return HttpClientUtils.execute(null, (HttpUriRequest)httpPost, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPostFiles(String url, Map<String, String> params, Map<String, File> files) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(60000).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        try {
            logger.info("doPost - start, url:{}", (Object)url);
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            logger.info("HttpClientUtils.doPost: get httpClinet, cost:{}", (Object)(end - start));
            HttpPost httpPost = new HttpPost(url);
            MultipartEntity multipartEntity = new MultipartEntity();
            long getPostTime = System.currentTimeMillis();
            logger.info("HttpClientUtils.doPost: getHttppOST cost:{}", (Object)(getPostTime - end));
            for (Map.Entry<String, File> entry : files.entrySet()) {
                multipartEntity.addPart(entry.getKey(), (ContentBody)new FileBody(entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                multipartEntity.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)multipartEntity);
            logger.info("doPost - execute, url:{}", (Object)url);
            String string = HttpClientUtils.execute((HttpClient)httpClient, (HttpUriRequest)httpPost, null, null);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("dopost exception - ", e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String doJsonPost(String url, Map<String, String> params, String charset) throws Exception {
        return HttpClientUtils.doJsonPost(url, params, charset, null);
    }

    public static String doJsonPost(String url, Map<String, String> params, String charset, Integer timeOut) throws Exception {
        String jsonPost = JacksonUtil.obj2Str(params);
        HttpPost httpPost = new HttpPost(url);
        StringEntity requestEntity = new StringEntity(jsonPost, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)requestEntity);
        return HttpClientUtils.execute(null, (HttpUriRequest)httpPost, charset, timeOut);
    }

    private static String execute(HttpClient httpClient, @NonNull HttpUriRequest request, String charset, Integer timeOut) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        boolean closeHttpClient = false;
        if (httpClient == null) {
            closeHttpClient = true;
            httpClient = timeOut != null ? HttpClientUtils.getHttpClient(timeOut) : HttpClientUtils.getHttpClient();
        }
        if (StringUtils.isBlank((String)charset)) {
            charset = CHARSET;
        }
        try {
            long current = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("send request:{}", (Object)request);
            }
            String result = (String)httpClient.execute(request, (ResponseHandler)new StringResponseHandler(request, charset));
            logger.info("cost:{} ms to execute http method:{},url:{}", new Object[]{System.currentTimeMillis() - current, request.getMethod(), request.getURI()});
            String string = result;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("do request exception - ", e);
        }
        finally {
            if (closeHttpClient && httpClient != null && httpClient instanceof Closeable) {
                try {
                    ((Closeable)httpClient).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] download(String url) throws Exception {
        try {
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpGet.abort();
                throw new IllegalStateException("download - error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            byte[] result = FileUtils.readBytes((InputStream)entity.getContent());
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            logger.warn("download exception - ", (Throwable)e);
            return null;
        }
    }

    public static byte[] downloadByPost(String url, Map<String, String> params) throws Exception {
        try {
            String jsonPost = JacksonUtil.obj2Str(params);
            HttpPost httpPost = new HttpPost(url);
            StringEntity requestEntity = new StringEntity(jsonPost, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)requestEntity);
            CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new IllegalStateException("download - error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            byte[] result = FileUtils.readBytes((InputStream)entity.getContent());
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            logger.warn("download exception - ", (Throwable)e);
            return null;
        }
    }

    static class StringResponseHandler
    implements ResponseHandler<String> {
        private HttpUriRequest request;
        private String charset;

        public StringResponseHandler(HttpUriRequest request, String charset) {
            this.request = request;
            this.charset = charset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            try {
                StatusLine status = response.getStatusLine();
                if (logger.isDebugEnabled()) {
                    logger.debug("doPost - execute end, url:{}, status:{}", (Object)this.request.getURI(), (Object)status);
                }
                if (status.getStatusCode() != 200) {
                    this.request.abort();
                    throw new RuntimeException("HttpClient,error status code :" + status);
                }
                HttpEntity responseEntity = response.getEntity();
                String result = null;
                if (responseEntity != null) {
                    result = EntityUtils.toString((HttpEntity)responseEntity, (String)this.charset);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("http response - url:{}, status:{}, response:{}", new Object[]{this.request.getURI(), status, result});
                }
                String string = result;
                return string;
            }
            finally {
                HttpEntity entity;
                if (response != null && (entity = response.getEntity()) != null) {
                    try {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

