/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.filter;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.baijia.tianxiao.filter.AppBaseResponse;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class WrapOrgTokenFilter
implements Filter {
    private static final String DEFAULTCOOKIENAME = "ORG_AUTH_TOKEN";
    private static final String DEFAULTPARAMNAME = "auth_token";
    private static final String DEFAULTPROPNAME = "passport-client.properties";
    private static final String DEFAULTVALIDTOKENURL = "valid.token.url";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String cookieName = "ORG_AUTH_TOKEN";
    private String paramName = "auth_token";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String encryptedToken = this.retrieveCookieValue(servletRequest);
        if (StringUtils.isNotBlank((CharSequence)encryptedToken)) {
            this.initTianxiaoContext(encryptedToken);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("initTianxiaoContext from cookie");
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("can't find token in cookie. try find by request param");
            }
            if (StringUtils.isNotBlank((CharSequence)(encryptedToken = servletRequest.getParameter(this.paramName)))) {
                if (!this.isValidAuthToken(encryptedToken)) {
                    JacksonUtil.writeObj((OutputStream)response.getOutputStream(), new AppBaseResponse("\u60a8\u7684\u8d26\u6237\u5df2\u7ecf\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55", 2100009999, null));
                    return;
                }
                this.initTianxiaoContext(encryptedToken);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("initTianxiaoContext from request");
                }
            }
        }
        chain.doFilter(request, response);
        this.clearTianxiaoContext();
    }

    private boolean isValidAuthToken(String encryptedToken) {
        block5: {
            try {
                String url;
                Properties prop = PropertiesReader.getProperties((String)DEFAULTPROPNAME);
                if (prop != null && StringUtils.isNotBlank((CharSequence)(url = prop.getProperty(DEFAULTVALIDTOKENURL)))) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put(DEFAULTPARAMNAME, encryptedToken);
                    String json = HttpClientUtils.doPost((String)url, params);
                    AppBaseResponse response = JacksonUtil.str2Obj(json, AppBaseResponse.class);
                    if (!BooleanUtils.toBoolean((String)response.getData().toString())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("valid auth_token fail.auth_token:{}", (Object)encryptedToken);
                        }
                        return false;
                    }
                }
            }
            catch (Throwable e) {
                if (!this.logger.isDebugEnabled()) break block5;
                this.logger.debug("valid auth_token error", e);
            }
        }
        return true;
    }

    public void destroy() {
    }

    protected String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    private void initTianxiaoContext(String encryptedToken) {
        try {
            AppAuthToken token = JacksonUtil.str2Obj(EncryptUtils.strDecode(encryptedToken), AppAuthToken.class);
            TianxiaoMContext.setOrgId(token.getUser_id().intValue());
            TianxiaoMContext.setOrgCascadeId(token.getCascade_user_id());
            TianxiaoMContext.setOrgCascadeAuth(token.getAuth());
            TianxiaoMContext.setTXCascadeId(token.getTx_cascade_user_id());
            TianxiaoMContext.setAppAuthToken(token);
        }
        catch (Exception e) {
            this.logger.error("decode token error! encryptedToken is :" + encryptedToken, (Throwable)e);
        }
    }

    private String retrieveCookieValue(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
        if (this.logger.isDebugEnabled()) {
            this.logger.info("get token from cookie | cookieName:{}, cookie value:{}", (Object)this.getCookieName(), (Object)(cookie == null ? null : cookie.getValue()));
        }
        return cookie == null ? null : cookie.getValue();
    }

    private void clearTianxiaoContext() {
        TianxiaoMContext.clear();
    }
}

