/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.constants.sms;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum TxSmsCodeType {
    APPLY(1, "\u7533\u8bf7\u8bd5\u7528\u5929\u6821", "\u9a8c\u8bc1\u7801{{code}}\uff08\u7533\u8bf7\u8bd5\u7528\u5929\u6821\uff09\uff0c\u8bf7\u6ce8\u610f\u4fdd\u5bc6\u5e76\u53ca\u65f6\u586b\u5199\u3002\u611f\u8c22\u60a8\u5bf9\u5929\u6821\u7684\u652f\u6301\uff0c\u54a8\u8be2\u7535\u8bdd4000-910-910\u3002", "_TX_APPLY_KEY_");

    private Integer code;
    private String label;
    private String msg;
    private String cacheKey;
    private static Map<String, TxSmsCodeType> noLogin;

    private TxSmsCodeType(Integer code, String label, String msg, String cacheKey) {
        this.code = code;
        this.label = label;
        this.msg = msg;
        this.cacheKey = cacheKey;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public static boolean isTypeValid(String type) {
        boolean result = false;
        if (StringUtils.isNotBlank((String)type)) {
            for (TxSmsCodeType codeType : TxSmsCodeType.values()) {
                if (!codeType.getCode().toString().equals(type)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static TxSmsCodeType getTxSmsCodeType(String type) {
        TxSmsCodeType smsCodeType = null;
        if (StringUtils.isNotBlank((String)type)) {
            for (TxSmsCodeType codeType : TxSmsCodeType.values()) {
                if (!codeType.getCode().toString().equals(type)) continue;
                smsCodeType = codeType;
                break;
            }
        }
        return smsCodeType;
    }

    public static String getSmsMsg(TxSmsCodeType codeType, String code) {
        return codeType.msg.replace("{{code}}", code);
    }

    public static boolean noLogin(String type) {
        return noLogin.containsKey(type);
    }

    static {
        noLogin = Maps.newHashMap();
        noLogin.put(TxSmsCodeType.APPLY.code.toString(), APPLY);
    }
}

