/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.constants.signup;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum PayType {
    ALIPAY_POS(2, "\u652f\u4ed8\u5b9d"),
    PAY_OB(3, "\u7f51\u94f6"),
    PAY_WEI_XIN1(5, "\u5fae\u4fe1"),
    PAY_WEI_XIN2(50, "\u5fae\u4fe1"),
    PAY_CFT(6, "\u8d22\u4ed8\u901a"),
    PAY_KQ_KJ(7, "\u5feb\u94b1\u5feb\u6377\u652f\u4ed8"),
    PAY_YL(8, "\u94f6\u8054\u652f\u4ed8"),
    PAY_YHQ(9, "\u4f18\u60e0\u5238"),
    PAY_ELSE(10, "\u5176\u4ed6\u91d1\u989d"),
    PAY_KJ(11, "\u5feb\u6377\u652f\u4ed8"),
    PAY_KQ(12, "\u5feb\u94b1"),
    PAY_KQ_OB(24, "\u5feb\u94b1\u7f51\u94f6\u652f\u4ed8"),
    PAY_BDZD(26, "\u767e\u5ea6\u76f4\u8fbe\u53f7\u652f\u4ed8"),
    PAY_POS_YINLIAN_CARD(27, "\u94f6\u8054POS\u652f\u4ed8"),
    PAY_POS_KUAIQIAN_CARD(28, "\u5feb\u94b1POS\u652f\u4ed8"),
    PAY_POS_CARD(0, "POS\u673a\u5237\u5361\u652f\u4ed8"),
    WX_POS(30, "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8"),
    ONLINE_PAYMENT(51, "\u5728\u7ebf\u652f\u4ed8"),
    CASH(4, "\u73b0\u91d1");

    private int code;
    private String note;
    private static Map<Integer, PayType> map;

    private PayType(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static PayType getPayTypeByCode(Integer code) {
        return map.get(code);
    }

    public static PayType getPayTypeByTypeStr(String payTypeStr) {
        if (StringUtils.isBlank((CharSequence)payTypeStr)) {
            return PAY_POS_CARD;
        }
        String[] payTypes = payTypeStr.split("_");
        if (payTypes.length == 0) {
            return PAY_POS_CARD;
        }
        String[] payTypeDetailStr = payTypes[0].split(":");
        if (payTypeDetailStr.length != 2) {
            return PAY_POS_CARD;
        }
        Integer typeValue = Integer.parseInt(payTypeDetailStr[0]);
        if (typeValue == 4) {
            return PAY_WEI_XIN2;
        }
        PayType payType = PayType.getPayTypeByCode(typeValue);
        if (payType == null) {
            return PAY_POS_CARD;
        }
        return payType;
    }

    static {
        map = Maps.newHashMap();
        for (PayType payType : PayType.values()) {
            map.put(payType.code, payType);
        }
    }
}

